/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.ConverterClassResolver;
import io.rxmicro.annotation.processor.cdi.component.InjectionResourceBuilder;
import io.rxmicro.annotation.processor.cdi.model.InjectionResource;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.cdi.Resource;
import io.rxmicro.cdi.resource.ResourceConverter;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class InjectionResourceBuilderImpl
implements InjectionResourceBuilder {
    @Inject
    private Set<ConverterClassResolver> converterClassResolvers;

    @Override
    public InjectionResource build(VariableElement field) {
        Resource resource = Optional.ofNullable(field.getAnnotation(Resource.class)).orElseGet(() -> (Resource)Annotations.getRequiredAnnotation((AnnotatedConstruct)field.getEnclosingElement(), Resource.class));
        String resourcePath = resource.value();
        TypeElement converterClass = this.getConverterClass(resource, resourcePath, field);
        return new InjectionResource(resourcePath, converterClass);
    }

    private TypeElement getConverterClass(Resource resource, String resourcePath, VariableElement field) {
        return Annotations.getAnnotationClassParameter(() -> ((Resource)resource).converterClass(), ResourceConverter.class).orElseGet(() -> this.converterClassResolvers.stream().filter(resolver -> resolver.isSupported(resourcePath)).findFirst().map(resolver -> resolver.resolve(resourcePath, field)).orElseThrow(() -> {
            throw new InterruptProcessingException((Element)field, "The RxMicro framework does not which converter must be used. Please specify the '@?.converterClass' parameter", new Object[]{Resource.class.getSimpleName()});
        }));
    }
}

