/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Singleton;
import com.mongodb.reactivestreams.client.MongoClient;
import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.spi.ConnectionFactory;
import io.rxmicro.annotation.processor.cdi.component.InjectionPointTypeBuilder;
import io.rxmicro.annotation.processor.cdi.component.impl.AbstractR2DBCConnectionProvider;
import io.rxmicro.annotation.processor.cdi.model.InjectionPointType;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import io.rxmicro.cdi.Resource;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.common.local.DeniedPackages;
import io.rxmicro.config.Config;
import io.rxmicro.data.mongo.MongoRepository;
import io.rxmicro.data.sql.r2dbc.postgresql.PostgreSQLRepository;
import io.rxmicro.rest.client.RestClient;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class InjectionPointTypeBuilderImpl
extends AbstractR2DBCConnectionProvider
implements InjectionPointTypeBuilder {
    private static final Set<Class<? extends Annotation>> REPOSITORY_ANNOTATIONS = Set.of(MongoRepository.class, PostgreSQLRepository.class);
    private static final List<String> SUPPORTED_MULTI_BINDER_TYPES = List.of(Set.class.getName(), Collection.class.getName(), Iterable.class.getName());
    private final List<Map.Entry<InjectionPointTypePredicate, InjectionPointType>> standardInjectionPointTypes = List.of(Map.entry((field, fieldType, modelName) -> REPOSITORY_ANNOTATIONS.stream().anyMatch(a -> fieldType.getAnnotation(a) != null), InjectionPointType.REPOSITORY), Map.entry((field, fieldType, modelName) -> this.isConfig(field, fieldType), InjectionPointType.CONFIG), Map.entry((field, fieldType, modelName) -> MongoClient.class.getName().equals(fieldType.getQualifiedName().toString()), InjectionPointType.MONGO_CLIENT), Map.entry((field, fieldType, modelName) -> fieldType.getAnnotation(RestClient.class) != null, InjectionPointType.REST_CLIENT), Map.entry((field, fieldType, modelName) -> field.getAnnotation(Resource.class) != null || field.getEnclosingElement().getAnnotation(Resource.class) != null, InjectionPointType.RESOURCE));

    @Override
    public InjectionPointType build(VariableElement field, String modelName) {
        return Elements.asTypeElement((TypeMirror)field.asType()).map(fieldType -> this.getStandardInjectionPointType(field, (TypeElement)fieldType, modelName).orElseGet(() -> this.getBeanType(field, (TypeElement)fieldType, modelName))).orElseThrow(() -> {
            throw new InterruptProcessingException((Element)field, "Unsupported injection type", new Object[0]);
        });
    }

    private InjectionPointType getBeanType(VariableElement field, TypeElement fieldType, String modelName) {
        if (SUPPORTED_MULTI_BINDER_TYPES.contains(ProcessingEnvironmentHelper.getTypes().erasure(field.asType()).toString())) {
            TypeValidators.validateGenericType((Element)field, (TypeMirror)field.asType(), (String)"Invalid multi binder type: ");
            TypeMirror genericType = ((DeclaredType)field.asType()).getTypeArguments().get(0);
            return Elements.asTypeElement((TypeMirror)genericType).map(genericTypeElement -> {
                if (this.getStandardInjectionPointType(field, (TypeElement)genericTypeElement, modelName).isEmpty()) {
                    return InjectionPointType.MULTI_BINDER;
                }
                throw new InterruptProcessingException((Element)field, "Expected bean type only!", new Object[0]);
            }).orElseThrow(() -> {
                throw new InterruptProcessingException((Element)field, "Unsupported generic bean type: ?", new Object[]{genericType});
            });
        }
        if (ProcessingEnvironmentHelper.getTypes().isAssignable(ProcessingEnvironmentHelper.getTypes().erasure(fieldType.asType()), ProcessingEnvironmentHelper.getTypes().erasure(ProcessingEnvironmentHelper.getElements().getTypeElement(Iterable.class.getName()).asType()))) {
            throw new InterruptProcessingException((Element)field, "For multi binder use the following containers only: ?", new Object[]{SUPPORTED_MULTI_BINDER_TYPES});
        }
        if (DeniedPackages.isDeniedPackage((String)Names.getPackageName((TypeElement)fieldType))) {
            throw new InterruptProcessingException((Element)field, "Current field couldn't be injected. Use supported standard types or custom type!", new Object[0]);
        }
        return InjectionPointType.BEAN;
    }

    private Optional<InjectionPointType> getStandardInjectionPointType(VariableElement field, TypeElement fieldType, String modelName) {
        if (ConnectionFactory.class.getName().equals(fieldType.getQualifiedName().toString())) {
            return Optional.of(this.getR2DBCConnectionProvider(field, modelName).getConnectionFactory());
        }
        if (ConnectionPool.class.getName().equals(fieldType.getQualifiedName().toString())) {
            return Optional.of(this.getR2DBCConnectionProvider(field, modelName).getConnectionPool());
        }
        for (Map.Entry<InjectionPointTypePredicate, InjectionPointType> type : this.standardInjectionPointTypes) {
            if (!type.getKey().test(field, fieldType, modelName)) continue;
            return Optional.of(type.getValue());
        }
        return Optional.empty();
    }

    private boolean isConfig(VariableElement field, TypeElement fieldType) {
        if (Config.class.getName().equals(fieldType.getQualifiedName().toString())) {
            throw new InterruptProcessingException((Element)field, "Config couldn't be injected. Use config class instead!", new Object[0]);
        }
        boolean isConfig = Elements.findSuperType((TypeElement)fieldType, Config.class).isPresent();
        if (isConfig) {
            if (fieldType.getKind() != ElementKind.CLASS) {
                throw new InterruptProcessingException((Element)field, "Expected class only!", new Object[0]);
            }
            if (fieldType.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new InterruptProcessingException((Element)field, "Expected not abstract class only!", new Object[0]);
            }
        }
        return isConfig;
    }

    private AbstractR2DBCConnectionProvider.R2DBCConnectionProvider getR2DBCConnectionProvider(VariableElement field, String modelName) {
        Set<AbstractR2DBCConnectionProvider.R2DBCConnectionProvider> set = this.getR2DBCConnectionProviders(field);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (modelName.toLowerCase(Locale.ENGLISH).contains("postgre")) {
            if (set.contains((Object)AbstractR2DBCConnectionProvider.R2DBCConnectionProvider.POSTGRE_SQL_CONNECTION_PROVIDER)) {
                return AbstractR2DBCConnectionProvider.R2DBCConnectionProvider.POSTGRE_SQL_CONNECTION_PROVIDER;
            }
            throw new InterruptProcessingException((Element)field, "Module '?' does not include. Add missing 'require ?' statement to module-info.java!", new Object[]{RxMicroModule.RX_MICRO_DATA_SQL_R2DBC_POSTGRESQL_MODULE.getName(), RxMicroModule.RX_MICRO_DATA_SQL_R2DBC_POSTGRESQL_MODULE.getName()});
        }
        throw new InterruptProcessingException((Element)field, "The RxMicro framework does not know which sql r2dbc module must be used to inject this dependency. Specify which module must be used!", new Object[0]);
    }

    private static interface InjectionPointTypePredicate {
        public boolean test(VariableElement var1, TypeElement var2, String var3);
    }
}

