/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.FieldOrMethodInjectionPointBuilder;
import io.rxmicro.annotation.processor.cdi.component.impl.AbstractInjectionPointBuilder;
import io.rxmicro.annotation.processor.cdi.model.InjectionPoint;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.MethodValidators;
import io.rxmicro.cdi.local.Annotations;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class FieldOrMethodInjectionPointBuilderImpl
extends AbstractInjectionPointBuilder
implements FieldOrMethodInjectionPointBuilder {
    @Override
    public List<InjectionPoint> build(TypeElement beanTypeElement) {
        List fields = Elements.allFields((TypeElement)beanTypeElement, f -> Annotations.INJECT_ANNOTATIONS.stream().anyMatch(a -> f.getAnnotation(a) != null));
        List methods = Elements.allMethods((TypeElement)beanTypeElement, f -> Annotations.INJECT_ANNOTATIONS.stream().anyMatch(a -> f.getAnnotation(a) != null) || f.getParameters().stream().flatMap(p -> p.getAnnotationMirrors().stream()).anyMatch(m -> Annotations.INJECT_ANNOTATIONS.stream().anyMatch(a -> a.getName().equals(m.getAnnotationType().toString()))));
        return Stream.concat(fields.stream().map(p -> this.build(beanTypeElement, (VariableElement)p)), methods.stream().peek(this::validateInjectionMethod).flatMap(m -> m.getParameters().stream()).map(p -> this.build(beanTypeElement, (VariableElement)p))).collect(Collectors.toList());
    }

    @Override
    protected InjectionPoint build(VariableElement field, InjectionPoint.Builder injectionPointBuilder) {
        if (field.getEnclosingElement() instanceof ExecutableElement) {
            injectionPointBuilder.setInjectionMethod((ExecutableElement)field.getEnclosingElement());
        }
        return injectionPointBuilder.build();
    }

    @Override
    protected boolean isRequired(Element element) {
        if (element.getEnclosingElement() instanceof ExecutableElement) {
            if (this.isInjectionAnnotationPresent(element)) {
                return super.isRequired(element);
            }
            return super.isRequired(element.getEnclosingElement());
        }
        return super.isRequired(element);
    }

    private void validateInjectionMethod(ExecutableElement method) {
        if (method.getParameters().size() == 0) {
            throw new InterruptProcessingException((Element)method, "Injection method must contain a parameter. This parameter is injectable component!", new Object[0]);
        }
        if (method.getParameters().size() > 1) {
            throw new InterruptProcessingException((Element)method, "Injection method must contain only one parameter. This parameter is injectable component!", new Object[0]);
        }
        MethodValidators.validateNotPrivateMethod((ExecutableElement)method, (String)"Injection method couldn't be a private. Use public or protected od <default> modifier instead!", (Object[])new Object[0]);
        MethodValidators.validateNotStaticMethod((ExecutableElement)method, (String)"Injection method couldn't be a static. Remove the 'static' modifier!", (Object[])new Object[0]);
        MethodValidators.validateNotAbstractMethod((ExecutableElement)method, (String)"Injection method couldn't be an abstract. Remove the 'abstract' modifier!", (Object[])new Object[0]);
    }
}

