/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.FactoryMethodFinder;
import io.rxmicro.annotation.processor.cdi.model.FactoryMethod;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.MethodValidators;
import io.rxmicro.cdi.Factory;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class FactoryMethodFinderImpl
implements FactoryMethodFinder {
    @Override
    public Optional<FactoryMethod> findMethod(TypeElement beanTypeElement) {
        List methods = Elements.allMethods((TypeElement)beanTypeElement, el -> el.getAnnotation(Factory.class) != null);
        this.validateMethods(methods, beanTypeElement);
        if (methods.size() > 1) {
            throw new InterruptProcessingException((Element)methods.get(0), "Only one factory method allowed per class. Remove the following methods: ?!", new Object[]{methods.stream().skip(1L).map(e -> Formats.format((String)"?.?(?)", (Object[])new Object[]{e.getEnclosingElement().asType().toString(), e.getSimpleName(), e.getParameters().stream().map(v -> v.asType().toString()).collect(Collectors.joining(", "))})).collect(Collectors.toList())});
        }
        return methods.stream().findFirst().map(FactoryMethod::new);
    }

    private void validateMethods(List<ExecutableElement> methods, TypeElement beanTypeElement) {
        for (ExecutableElement method : methods) {
            MethodValidators.validateStaticMethod((ExecutableElement)method, (String)"Factory method must be static.", (Object[])new Object[0]);
            MethodValidators.validateNotNativeMethod((ExecutableElement)method, (String)"Factory method couldn't be native.", (Object[])new Object[0]);
            MethodValidators.validateNotSynchronizedMethod((ExecutableElement)method, (String)"Factory method method couldn't be synchronized.", (Object[])new Object[0]);
            MethodValidators.validateWithoutParametersMethod((ExecutableElement)method, (String)"Factory method method couldn't contain any parameters.", (Object[])new Object[0]);
            if (ProcessingEnvironmentHelper.getTypes().erasure(method.getReturnType()).toString().equals(beanTypeElement.getQualifiedName().toString())) continue;
            throw new InterruptProcessingException((Element)method, "Factory method must return an instance of '?' type!", new Object[]{beanTypeElement.getQualifiedName().toString()});
        }
    }
}

