/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Singleton;
import com.mongodb.reactivestreams.client.MongoClient;
import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.spi.ConnectionFactory;
import io.rxmicro.annotation.processor.cdi.component.DefaultNameBuilder;
import io.rxmicro.annotation.processor.cdi.component.impl.AbstractR2DBCConnectionProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.cdi.local.Annotations;
import io.rxmicro.common.util.Strings;
import io.rxmicro.config.Config;
import io.rxmicro.data.mongo.MongoConfig;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class DefaultNameBuilderImpl
extends AbstractR2DBCConnectionProvider
implements DefaultNameBuilder {
    @Override
    public String getName(Element element) {
        if (element instanceof TypeElement) {
            return Strings.unCapitalize((String)element.getSimpleName().toString());
        }
        if (Elements.findSuperType((TypeElement)((TypeElement)Elements.asTypeElement((TypeMirror)element.asType()).orElseThrow()), Config.class).isPresent()) {
            return Config.getDefaultNameSpace((String)Names.getSimpleName((TypeMirror)element.asType()));
        }
        if (MongoClient.class.getName().equals(element.asType().toString())) {
            return Config.getDefaultNameSpace(MongoConfig.class);
        }
        if (ConnectionFactory.class.getName().equals(element.asType().toString()) || ConnectionPool.class.getName().equals(element.asType().toString())) {
            return Config.getDefaultNameSpace(this.getR2DBCConnectionProvider(element).getDataBaseConfigClass());
        }
        return element.getSimpleName().toString();
    }

    private AbstractR2DBCConnectionProvider.R2DBCConnectionProvider getR2DBCConnectionProvider(Element element) {
        Set<AbstractR2DBCConnectionProvider.R2DBCConnectionProvider> set = this.getR2DBCConnectionProviders(element);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        throw new InterruptProcessingException(element, "Use qualifier annotation to set config name space. Supported qualifier annotations are '?'", new Object[]{Annotations.QUALIFIER_ANNOTATIONS});
    }
}

