/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.ConstructorInjectionPointBuilder;
import io.rxmicro.annotation.processor.cdi.component.impl.AbstractInjectionPointBuilder;
import io.rxmicro.annotation.processor.cdi.model.InjectionPoint;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import io.rxmicro.cdi.local.Annotations;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class ConstructorInjectionPointBuilderImpl
extends AbstractInjectionPointBuilder
implements ConstructorInjectionPointBuilder {
    @Override
    public boolean isConstructorInjection(TypeElement beanTypeElement) {
        for (ExecutableElement constructor : Elements.allConstructors((TypeElement)beanTypeElement)) {
            if (Annotations.INJECT_ANNOTATIONS.stream().anyMatch(a -> constructor.getAnnotation(a) != null)) {
                return true;
            }
            for (VariableElement variableElement : constructor.getParameters()) {
                if (!Annotations.INJECT_ANNOTATIONS.stream().anyMatch(a -> parameter.getAnnotation(a) != null)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<InjectionPoint> build(TypeElement beanTypeElement) {
        List constructors = Elements.allConstructors((TypeElement)beanTypeElement);
        List fields = Elements.allFields((TypeElement)beanTypeElement, f -> Annotations.INJECT_ANNOTATIONS.stream().anyMatch(a -> f.getAnnotation(a) != null));
        List methods = Elements.allMethods((TypeElement)beanTypeElement, f -> Annotations.INJECT_ANNOTATIONS.stream().anyMatch(a -> f.getAnnotation(a) != null));
        this.validate(constructors, fields, methods);
        return ((ExecutableElement)constructors.get(0)).getParameters().stream().map(p -> this.build(beanTypeElement, (VariableElement)p)).collect(Collectors.toList());
    }

    @Override
    protected InjectionPoint build(VariableElement field, InjectionPoint.Builder injectionPointBuilder) {
        return injectionPointBuilder.setConstructorInjection(true).build();
    }

    @Override
    protected boolean isRequired(Element element) {
        if (this.isInjectionAnnotationPresent(element)) {
            return super.isRequired(element);
        }
        return super.isRequired(element.getEnclosingElement());
    }

    private void validate(List<ExecutableElement> constructors, List<VariableElement> fields, List<ExecutableElement> methods) {
        if (constructors.size() > 1) {
            throw new InterruptProcessingException((Element)constructors.get(constructors.size() - 1), "Class must declare only one constructor. Remove redundant constructor(s)!", new Object[0]);
        }
        if (!fields.isEmpty()) {
            throw new InterruptProcessingException((Element)fields.get(0), "Field injection is not supported if class already uses constructor injection. Remove injection annotations from field(s): ?", new Object[]{fields.stream().map(e -> e.getSimpleName().toString()).collect(Collectors.joining(", "))});
        }
        if (!methods.isEmpty()) {
            throw new InterruptProcessingException((Element)methods.get(0), "Method injection is not supported if class already uses constructor injection. Remove injection annotations from method(s): ?", new Object[]{methods.stream().map(e -> Formats.format((String)"?(?)", (Object[])new Object[]{e.getSimpleName(), e.getParameters().stream().map(p -> p.asType().toString()).collect(Collectors.joining(", "))})).collect(Collectors.joining(", "))});
        }
        this.validateConstructor(constructors.get(0));
    }

    private void validateConstructor(ExecutableElement constructor) {
        if (constructor.getParameters().isEmpty()) {
            throw new InterruptProcessingException((Element)constructor, "Constructor must declare at least one parameter. Add missing parameter(s) or remove '@?' annotation", new Object[]{constructor.getAnnotationMirrors().stream().filter(a -> Annotations.INJECT_ANNOTATIONS.stream().anyMatch(cl -> a.getAnnotationType().toString().equals(cl.getName()))).map(a -> a.getAnnotationType().toString()).collect(Collectors.joining(", "))});
        }
        TypeValidators.validateAccessibleConstructor((ExecutableElement)constructor);
        if (Annotations.INJECT_ANNOTATIONS.stream().noneMatch(a -> constructor.getAnnotation(a) != null)) {
            for (VariableElement variableElement : constructor.getParameters()) {
                if (!Annotations.INJECT_ANNOTATIONS.stream().noneMatch(a -> parameter.getAnnotation(a) != null)) continue;
                throw new InterruptProcessingException((Element)variableElement, "Missing inject annotation per constructor parameter: '?'", new Object[]{variableElement});
            }
        }
    }
}

