/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.BeanWithoutInjectionsClassStructureBuilder;
import io.rxmicro.annotation.processor.cdi.component.impl.AbstractBeanDefinitionClassStructureBuilder;
import io.rxmicro.annotation.processor.cdi.model.BeanSupplierClassStructure;
import io.rxmicro.annotation.processor.cdi.model.InjectionPoint;
import io.rxmicro.annotation.processor.cdi.model.InjectionPointType;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.local.DeniedPackages;
import io.rxmicro.common.util.ExCollectors;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

@Singleton
public final class BeanWithoutInjectionsClassStructureBuilderImpl
extends AbstractBeanDefinitionClassStructureBuilder
implements BeanWithoutInjectionsClassStructureBuilder {
    @Override
    public Set<BeanSupplierClassStructure> build(EnvironmentContext environmentContext, List<InjectionPoint> injectionPoints, Set<String> alreadyProcessedClasses) {
        HashSet<BeanSupplierClassStructure> result = new HashSet<BeanSupplierClassStructure>();
        Map<String, Set<TypeElement>> implMap = this.buildImplMap(environmentContext);
        for (InjectionPoint injectionPoint : injectionPoints) {
            String type = injectionPoint.getType() == InjectionPointType.BEAN ? injectionPoint.getModelField().getFieldClass().toString() : (injectionPoint.getType() == InjectionPointType.MULTI_BINDER ? ((DeclaredType)injectionPoint.getModelField().getFieldClass()).getTypeArguments().get(0).toString() : null);
            if (type == null) continue;
            Optional.ofNullable(implMap.get(type)).ifPresent(typeElements -> typeElements.forEach(typeElement -> {
                if (!alreadyProcessedClasses.contains(typeElement.asType().toString())) {
                    result.add(this.buildCDIBeanDefinitionClassStructure((TypeElement)typeElement));
                }
            }));
        }
        return result;
    }

    private Map<String, Set<TypeElement>> buildImplMap(EnvironmentContext environmentContext) {
        Set<TypeElement> allClassesAtAllNotStandardModules = this.getAllClassesAtAllNotStandardModules(environmentContext);
        HashMap<String, Set<TypeElement>> map = new HashMap<String, Set<TypeElement>>();
        for (TypeElement typeElement : allClassesAtAllNotStandardModules) {
            Elements.allSuperTypesAndInterfaces((TypeElement)typeElement, (boolean)true, (boolean)true).forEach(superType -> this.addSubType((Map<String, Set<TypeElement>>)map, typeElement, (TypeElement)superType));
            this.getFactoryClassEntry(typeElement).ifPresent(entry -> this.addSubType(map, typeElement, (TypeElement)entry.getValue()));
        }
        return map;
    }

    private void addSubType(Map<String, Set<TypeElement>> map, TypeElement typeElement, TypeElement superType) {
        Set typeElements = map.computeIfAbsent(superType.asType().toString(), k -> new HashSet());
        if (typeElements.stream().noneMatch(te -> te.asType().toString().equals(typeElement.asType().toString()))) {
            typeElements.add(typeElement);
        }
    }

    private Set<TypeElement> getAllClassesAtAllNotStandardModules(EnvironmentContext environmentContext) {
        Set packageElements = ProcessingEnvironmentHelper.getElements().getAllModuleElements().stream().flatMap(me -> me.getEnclosedElements().stream().map(e -> (PackageElement)e)).filter(pe -> !DeniedPackages.isDeniedPackage((String)pe.getQualifiedName().toString())).collect(Collectors.toSet());
        return (Set)packageElements.stream().flatMap(pe -> pe.getEnclosedElements().stream().filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e)).filter(arg_0 -> ((EnvironmentContext)environmentContext).isRxMicroClassShouldBeProcessed(arg_0)).filter(te -> te.getKind() == ElementKind.CLASS).collect(ExCollectors.toTreeSet(Comparator.comparing(o -> o.getQualifiedName().toString())));
    }
}

