/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.BeanRegistrationQualifierRuleBuilder;
import io.rxmicro.annotation.processor.cdi.component.DefaultNameBuilder;
import io.rxmicro.annotation.processor.cdi.component.UserDefinedNameBuilder;
import io.rxmicro.annotation.processor.cdi.model.QualifierRule;
import io.rxmicro.annotation.processor.cdi.model.qualifier.ByTypeAndNameQualifierRule;
import io.rxmicro.annotation.processor.cdi.model.qualifier.ByTypeQualifierRule;
import io.rxmicro.annotation.processor.common.util.Elements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public class BeanRegistrationQualifierRuleBuilderImpl
implements BeanRegistrationQualifierRuleBuilder {
    @Inject
    private UserDefinedNameBuilder userDefinedNameBuilder;
    @Inject
    private DefaultNameBuilder defaultNameBuilder;

    @Override
    public List<QualifierRule> build(TypeElement typeElement) {
        ArrayList<QualifierRule> result = new ArrayList<QualifierRule>(3);
        String modelName = this.userDefinedNameBuilder.getName(typeElement).orElseGet(() -> this.defaultNameBuilder.getName(typeElement));
        result.add(new ByTypeQualifierRule(typeElement));
        Elements.allSuperTypesAndInterfaces((TypeElement)typeElement, (boolean)false, (boolean)true).forEach(te -> result.addAll(Arrays.asList(new ByTypeAndNameQualifierRule((TypeElement)te, modelName), new ByTypeQualifierRule((TypeElement)te))));
        return result;
    }

    @Override
    public List<QualifierRule> build(ExecutableElement executableElement) {
        Optional<String> optionalName = this.userDefinedNameBuilder.getName(executableElement);
        if (optionalName.isPresent()) {
            return List.of(new ByTypeAndNameQualifierRule(executableElement.getReturnType(), optionalName.get()));
        }
        optionalName = this.userDefinedNameBuilder.getName(executableElement.getEnclosingElement());
        if (optionalName.isPresent()) {
            return List.of(new ByTypeAndNameQualifierRule(executableElement.getReturnType(), optionalName.get()));
        }
        return Elements.asTypeElement((TypeMirror)executableElement.getReturnType()).stream().flatMap(te -> Elements.allSuperTypesAndInterfaces((TypeElement)te, (boolean)true, (boolean)true).stream().flatMap(t -> Stream.of(new ByTypeQualifierRule((TypeElement)t), new ByTypeAndNameQualifierRule(executableElement.getReturnType(), this.defaultNameBuilder.getName((Element)te))))).collect(Collectors.toList());
    }
}

