/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import io.rxmicro.annotation.processor.cdi.model.InjectionPointType;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.common.util.Requires;
import io.rxmicro.data.sql.SQLPooledDatabaseConfig;
import io.rxmicro.data.sql.r2dbc.postgresql.PostgreSQLConfig;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public abstract class AbstractR2DBCConnectionProvider {
    private final Map<String, R2DBCConnectionProvider> map = Map.of(RxMicroModule.RX_MICRO_DATA_SQL_R2DBC_POSTGRESQL_MODULE.getName(), R2DBCConnectionProvider.POSTGRE_SQL_CONNECTION_PROVIDER);

    protected final Set<R2DBCConnectionProvider> getR2DBCConnectionProviders(Element element) {
        Set sqlModuleElementNames = ProcessingEnvironmentHelper.getElements().getAllModuleElements().stream().map(me -> me.getQualifiedName().toString()).filter(RxMicroModule::isSqlR2DBCModule).collect(Collectors.toSet());
        if (sqlModuleElementNames.size() == 1) {
            String moduleName = (String)sqlModuleElementNames.iterator().next();
            if (RxMicroModule.RX_MICRO_DATA_SQL_R2DBC_POSTGRESQL_MODULE.getName().equals(moduleName)) {
                return Set.of(R2DBCConnectionProvider.POSTGRE_SQL_CONNECTION_PROVIDER);
            }
            throw new InternalErrorException("Unsupported SQL R2DBC module: '?'", new Object[]{moduleName});
        }
        if (sqlModuleElementNames.isEmpty()) {
            throw new InterruptProcessingException(element, "Missing sql r2dbc module. Add missing module to project!", new Object[0]);
        }
        return sqlModuleElementNames.stream().map(n -> (R2DBCConnectionProvider)((Object)((Object)Requires.require((Object)((Object)this.map.get(n)), (String)("Missing R2DBCConnectionProvider enum constant: " + n), (Supplier[])new Supplier[0])))).collect(Collectors.toSet());
    }

    protected static enum R2DBCConnectionProvider {
        POSTGRE_SQL_CONNECTION_PROVIDER(InjectionPointType.POSTGRE_SQL_CONNECTION_FACTORY, InjectionPointType.POSTGRE_SQL_CONNECTION_POOL, PostgreSQLConfig.class);

        private final InjectionPointType connectionFactory;
        private final InjectionPointType connectionPool;
        private final Class<? extends SQLPooledDatabaseConfig> dataBaseConfigClass;

        private R2DBCConnectionProvider(InjectionPointType connectionFactory, InjectionPointType connectionPool, Class<? extends SQLPooledDatabaseConfig> dataBaseConfigClass) {
            this.connectionFactory = connectionFactory;
            this.connectionPool = connectionPool;
            this.dataBaseConfigClass = dataBaseConfigClass;
        }

        public InjectionPointType getConnectionFactory() {
            return this.connectionFactory;
        }

        public InjectionPointType getConnectionPool() {
            return this.connectionPool;
        }

        public Class<? extends SQLPooledDatabaseConfig> getDataBaseConfigClass() {
            return this.dataBaseConfigClass;
        }
    }
}

