/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.cdi.component.BeanInjectionPointQualifierRuleBuilder;
import io.rxmicro.annotation.processor.cdi.component.DefaultNameBuilder;
import io.rxmicro.annotation.processor.cdi.component.InjectionPointTypeBuilder;
import io.rxmicro.annotation.processor.cdi.component.InjectionResourceBuilder;
import io.rxmicro.annotation.processor.cdi.component.UserDefinedNameBuilder;
import io.rxmicro.annotation.processor.cdi.model.InjectionModelField;
import io.rxmicro.annotation.processor.cdi.model.InjectionPoint;
import io.rxmicro.annotation.processor.cdi.model.InjectionPointType;
import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.SupportedAnnotations;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.cdi.Autowired;
import io.rxmicro.cdi.Resource;
import io.rxmicro.cdi.local.Annotations;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public abstract class AbstractInjectionPointBuilder {
    @Inject
    private UserDefinedNameBuilder userDefinedNameBuilder;
    @Inject
    private DefaultNameBuilder defaultNameBuilder;
    @Inject
    private InjectionPointTypeBuilder injectionPointTypeBuilder;
    @Inject
    private BeanInjectionPointQualifierRuleBuilder beanInjectionPointQualifierRuleBuilder;
    @Inject
    private InjectionResourceBuilder injectionResourceBuilder;

    final InjectionPoint build(TypeElement beanTypeElement, VariableElement field) {
        AnnotationValidators.validateOnlyOneAnnotationPerElement((Element)field, field.getAnnotationMirrors(), (SupportedAnnotations)new SupportedAnnotations(Annotations.INJECT_ANNOTATIONS));
        String modelName = this.userDefinedNameBuilder.getName(field).orElseGet(() -> this.defaultNameBuilder.getName(field));
        InjectionPointType type = this.injectionPointTypeBuilder.build(field, modelName);
        boolean required = this.isRequired(field);
        InjectionPoint.Builder injectionPointBuilder = new InjectionPoint.Builder().setType(type).setModelField(new InjectionModelField(this.buildAnnotatedModelElement(field), modelName)).setRequired(required);
        if (type == InjectionPointType.BEAN) {
            injectionPointBuilder.setQualifierRules(this.beanInjectionPointQualifierRuleBuilder.build(field));
        } else if (type == InjectionPointType.RESOURCE) {
            injectionPointBuilder.setInjectionResource(this.injectionResourceBuilder.build(field));
        } else if (!required) {
            throw new InterruptProcessingException((Element)field, "Optional injection not supported. Remove annotation parameter!", new Object[0]);
        }
        return this.build(field, injectionPointBuilder);
    }

    protected abstract InjectionPoint build(VariableElement var1, InjectionPoint.Builder var2);

    protected boolean isRequired(Element element) {
        return Optional.ofNullable(element.getAnnotation(io.rxmicro.cdi.Inject.class)).map(i -> !i.optional()).orElseGet(() -> Optional.ofNullable(element.getAnnotation(Autowired.class)).map(Autowired::required).orElseGet(() -> Optional.ofNullable(element.getAnnotation(Resource.class)).map(i -> !i.optional()).orElseThrow(Errors.createInternalErrorSupplier((String)"@? or @? or @? annotation must be present!", (Object[])new Object[]{io.rxmicro.cdi.Inject.class.getSimpleName(), Autowired.class.getSimpleName(), Resource.class.getSimpleName()}))));
    }

    protected final boolean isInjectionAnnotationPresent(Element element) {
        return Optional.ofNullable(element.getAnnotation(io.rxmicro.cdi.Inject.class)).map(i -> i).or(() -> Optional.ofNullable(element.getAnnotation(Autowired.class))).or(() -> Optional.ofNullable(element.getAnnotation(Resource.class))).isPresent();
    }

    private AnnotatedModelElement buildAnnotatedModelElement(VariableElement variableElement) {
        return new AnnotatedModelElement(variableElement);
    }
}

