/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.cdi.component.BeanRegistrationQualifierRuleBuilder;
import io.rxmicro.annotation.processor.cdi.component.ConstructorInjectionPointBuilder;
import io.rxmicro.annotation.processor.cdi.component.FactoryMethodFinder;
import io.rxmicro.annotation.processor.cdi.component.FieldOrMethodInjectionPointBuilder;
import io.rxmicro.annotation.processor.cdi.component.PostConstructMethodFinder;
import io.rxmicro.annotation.processor.cdi.model.BeanDefinition;
import io.rxmicro.annotation.processor.cdi.model.BeanSupplierClassStructure;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import io.rxmicro.cdi.Factory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

abstract class AbstractBeanDefinitionClassStructureBuilder {
    @Inject
    private ConstructorInjectionPointBuilder constructorInjectionPointBuilder;
    @Inject
    private FieldOrMethodInjectionPointBuilder fieldOrMethodInjectionPointBuilder;
    @Inject
    private PostConstructMethodFinder postConstructMethodFinder;
    @Inject
    private FactoryMethodFinder factoryMethodFinder;
    @Inject
    private BeanRegistrationQualifierRuleBuilder beanRegistrationQualifierRuleBuilder;

    AbstractBeanDefinitionClassStructureBuilder() {
    }

    final BeanSupplierClassStructure buildCDIBeanDefinitionClassStructure(TypeElement beanTypeElement) {
        BeanDefinition.Builder builder = new BeanDefinition.Builder().setBeanTypeElement(beanTypeElement);
        if (this.constructorInjectionPointBuilder.isConstructorInjection(beanTypeElement)) {
            builder.setConstructorInjection(true).setInjectionPoints(this.constructorInjectionPointBuilder.build(beanTypeElement));
        } else {
            builder.setInjectionPoints(this.fieldOrMethodInjectionPointBuilder.build(beanTypeElement));
        }
        this.postConstructMethodFinder.findMethod(beanTypeElement).ifPresent(builder::setPostConstructMethod);
        this.factoryMethodFinder.findMethod(beanTypeElement).ifPresent(builder::setFactoryMethod);
        this.getFactoryClassEntry(beanTypeElement).ifPresent(e -> builder.setFactoryTypeProviderMethod((ExecutableElement)e.getKey()).setFactoryTypeProviderType((TypeElement)e.getValue()));
        BeanDefinition beanDefinition = builder.build();
        this.validate(beanTypeElement, beanDefinition);
        return new BeanSupplierClassStructure(beanDefinition, this.beanRegistrationQualifierRuleBuilder.build(beanDefinition.getBeanTypeElement()), beanDefinition.getFactoryTypeProviderMethod().map(e -> this.beanRegistrationQualifierRuleBuilder.build((ExecutableElement)e)).orElse(List.of()));
    }

    protected final Optional<Map.Entry<ExecutableElement, TypeElement>> getFactoryClassEntry(TypeElement beanTypeElement) {
        boolean result;
        boolean bl = result = beanTypeElement.getAnnotation(Factory.class) != null;
        if (result) {
            TypeMirror supplierType = (TypeMirror)Elements.findSuperType((TypeElement)beanTypeElement, Supplier.class).orElseThrow(() -> {
                throw new InterruptProcessingException((Element)beanTypeElement, "Factory bean must implement '?' interface", new Object[]{Supplier.class.getName()});
            });
            TypeValidators.validateGenericType((Element)beanTypeElement, (TypeMirror)supplierType);
            TypeMirror factoryTypeMirror = ((DeclaredType)supplierType).getTypeArguments().get(0);
            TypeElement typeElement = (TypeElement)Elements.asTypeElement((TypeMirror)factoryTypeMirror).orElseThrow(() -> {
                throw new InterruptProcessingException((Element)beanTypeElement, "? is not class", new Object[]{ProcessingEnvironmentHelper.getTypes().erasure(factoryTypeMirror).toString()});
            });
            return Elements.allMethods((TypeElement)beanTypeElement, e -> "get".equals(e.getSimpleName().toString()) && e.getParameters().isEmpty()).stream().findFirst().map(e -> Map.entry(e, typeElement));
        }
        return Optional.empty();
    }

    private void validate(TypeElement beanTypeElement, BeanDefinition beanDefinition) {
        TypeValidators.validateThatElementIsPublic((Element)beanTypeElement, (String)"Class must be a public. Add 'public' modifier!", (Object[])new Object[0]);
        if (!beanDefinition.isFactoryMethodPresent() && !beanDefinition.isConstructorInjection()) {
            TypeValidators.validateAccessibleDefaultConstructor((TypeElement)beanTypeElement);
        }
    }
}

