/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.rxmicro.annotation.processor.cdi.CDIDependenciesModule;
import io.rxmicro.annotation.processor.cdi.component.BeanWithInjectionsClassStructureBuilder;
import io.rxmicro.annotation.processor.cdi.component.BeanWithoutInjectionsClassStructureBuilder;
import io.rxmicro.annotation.processor.cdi.model.BeanFactoryImplClassStructure;
import io.rxmicro.annotation.processor.cdi.model.BeanSupplierClassStructure;
import io.rxmicro.annotation.processor.common.CommonDependenciesModule;
import io.rxmicro.annotation.processor.common.FormatSourceCodeDependenciesModule;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.model.CDIUsageCandidateClassStructure;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.util.Injects;
import io.rxmicro.cdi.local.Annotations;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public final class CDIClassStructuresBuilder
extends AbstractModuleClassStructuresBuilder {
    private Set<String> beanDefinitionTypes = Set.of();
    @Inject
    private BeanWithInjectionsClassStructureBuilder beanWithInjectionsClassStructureBuilder;
    @Inject
    private BeanWithoutInjectionsClassStructureBuilder beanWithoutInjectionsClassStructureBuilder;

    public static CDIClassStructuresBuilder create() {
        CDIClassStructuresBuilder builder = new CDIClassStructuresBuilder();
        Injects.injectDependencies((Object)((Object)builder), (Module[])new Module[]{new FormatSourceCodeDependenciesModule(), new CommonDependenciesModule(), new CDIDependenciesModule()});
        return builder;
    }

    private CDIClassStructuresBuilder() {
    }

    public String getBuilderName() {
        return "cdi-annotation-processor-module";
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Annotations.INJECT_ANNOTATIONS.stream().map(Class::getName).collect(Collectors.toSet());
    }

    public Set<? extends ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<BeanSupplierClassStructure> beanWithInjectionsClassStructures = this.beanWithInjectionsClassStructureBuilder.build(environmentContext, annotations, roundEnv);
        Set<BeanSupplierClassStructure> beanWithoutInjectionsClassStructures = this.beanWithoutInjectionsClassStructureBuilder.build(environmentContext, beanWithInjectionsClassStructures.stream().flatMap(s -> s.getBeanDefinition().getInjectionPoints().stream()).collect(Collectors.toList()), beanWithInjectionsClassStructures.stream().map(s -> s.getBeanDefinition().getBeanTypeElement().asType().toString()).collect(Collectors.toSet()));
        this.logAllFoundBeanSuppliers(beanWithInjectionsClassStructures, beanWithoutInjectionsClassStructures);
        HashSet<BeanSupplierClassStructure> beanSupplierClassStructures = new HashSet<BeanSupplierClassStructure>();
        beanSupplierClassStructures.addAll(beanWithInjectionsClassStructures);
        beanSupplierClassStructures.addAll(beanWithoutInjectionsClassStructures);
        this.beanDefinitionTypes = beanSupplierClassStructures.stream().map(s -> s.getBeanDefinition().getBeanTypeElement().asType().toString()).collect(Collectors.toSet());
        return Stream.concat(beanSupplierClassStructures.stream(), Stream.of(new BeanFactoryImplClassStructure(beanSupplierClassStructures))).collect(Collectors.toSet());
    }

    private void logAllFoundBeanSuppliers(Set<BeanSupplierClassStructure> beanWithInjectionsClassStructures, Set<BeanSupplierClassStructure> beanWithoutInjectionsClassStructures) {
        if (this.isDebugEnabled()) {
            this.logClassStructureStorageItem("bean with injection(s) supplier(s)", beanWithInjectionsClassStructures);
            this.logClassStructureStorageItem("bean without injection(s) supplier(s)", beanWithoutInjectionsClassStructures);
        }
    }

    public void afterAllClassStructuresBuilt(Set<? extends ClassStructure> classStructures) {
        classStructures.stream().filter(s -> s instanceof CDIUsageCandidateClassStructure).map(s -> (CDIUsageCandidateClassStructure)s).forEach(candidate -> {
            if (this.beanDefinitionTypes.contains(candidate.getBeanFullClassName())) {
                candidate.setUseCDI(true);
            }
        });
    }
}

