/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.Message;
import io.protostuff.MsgpackXOutput;
import io.protostuff.Output;
import io.protostuff.Schema;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public final class MsgpackXIOUtil {
    private MsgpackXIOUtil() {
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        MsgpackXOutput output = new MsgpackXOutput(buffer, numeric, schema);
        try {
            LinkedBuffer objectHeader = output.writeStartObject();
            schema.writeTo((Output)output, message);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject(objectHeader);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException", e);
        }
        return output.toByteArray();
    }

    public static <T> void writeTo(LinkedBuffer buffer, T message, Schema<T> schema, boolean numeric) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        MsgpackXOutput output = new MsgpackXOutput(buffer, numeric, schema);
        try {
            LinkedBuffer objectStarter = output.writeStartObject();
            schema.writeTo((Output)output, message);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject(objectStarter);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static <T extends Message<T>> void writeTo(OutputStream out, T message, boolean numeric, LinkedBuffer buffer) throws IOException {
        MsgpackXIOUtil.writeTo(out, message, message.cachedSchema(), numeric, buffer);
    }

    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        MsgpackXOutput output = new MsgpackXOutput(buffer, numeric, schema);
        LinkedBuffer objectHeader = output.writeStartObject();
        schema.writeTo((Output)output, message);
        if (output.isLastRepeated()) {
            output.writeEndArray();
        }
        output.writeEndObject(objectHeader);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
    }

    public static <T> void writeListTo(LinkedBuffer buffer, List<T> messages, Schema<T> schema, boolean numeric) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        if (messages.isEmpty()) {
            return;
        }
        MsgpackXOutput output = new MsgpackXOutput(buffer, numeric, schema);
        try {
            for (T m : messages) {
                LinkedBuffer objectStarter = output.writeStartObject();
                schema.writeTo((Output)output, m);
                if (output.isLastRepeated()) {
                    output.writeEndArray();
                }
                output.writeEndObject(objectStarter);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        if (messages.isEmpty()) {
            return;
        }
        MsgpackXOutput output = new MsgpackXOutput(buffer, numeric, schema);
        for (T m : messages) {
            LinkedBuffer objectStarter = output.writeStartObject();
            schema.writeTo((Output)output, m);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject(objectStarter);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
            output.clear();
        }
    }
}

