/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.StringSerializer;
import io.protostuff.WriteSession;
import io.protostuff.WriteSink;
import java.io.IOException;
import org.msgpack.core.MessagePack;

public final class MsgpackWriteSink {
    private final WriteSink sink;
    private final boolean str8FormatSupport;

    public MsgpackWriteSink(WriteSink sink, MessagePack.PackerConfig config) {
        this(sink, config.isStr8FormatSupport());
    }

    public MsgpackWriteSink(WriteSink sink, boolean str8FormatSupport) {
        this.sink = sink;
        this.str8FormatSupport = str8FormatSupport;
    }

    private LinkedBuffer writeByteAndByte(byte b, byte v, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.sink.writeByte(v, session, this.sink.writeByte(b, session, lb));
    }

    private LinkedBuffer writeByteAndShort(byte b, short v, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.sink.writeInt16((int)v, session, this.sink.writeByte(b, session, lb));
    }

    private LinkedBuffer writeByteAndInt(byte b, int v, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.sink.writeInt32(v, session, this.sink.writeByte(b, session, lb));
    }

    private LinkedBuffer writeByteAndLong(byte b, long v, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.sink.writeInt64(v, session, this.sink.writeByte(b, session, lb));
    }

    public LinkedBuffer packInt(int r, WriteSession session, LinkedBuffer lb) throws IOException {
        if (r < -32) {
            if (r < Short.MIN_VALUE) {
                return this.writeByteAndInt((byte)-46, r, session, lb);
            }
            if (r < -128) {
                return this.writeByteAndShort((byte)-47, (short)r, session, lb);
            }
            return this.writeByteAndByte((byte)-48, (byte)r, session, lb);
        }
        if (r < 128) {
            return this.sink.writeByte((byte)r, session, lb);
        }
        if (r < 256) {
            return this.writeByteAndByte((byte)-52, (byte)r, session, lb);
        }
        if (r < 65536) {
            return this.writeByteAndShort((byte)-51, (short)r, session, lb);
        }
        return this.writeByteAndInt((byte)-50, r, session, lb);
    }

    public LinkedBuffer packLong(long v, WriteSession session, LinkedBuffer lb) throws IOException {
        if (v < -32L) {
            if (v < -32768L) {
                if (v < Integer.MIN_VALUE) {
                    return this.writeByteAndLong((byte)-45, v, session, lb);
                }
                return this.writeByteAndInt((byte)-46, (int)v, session, lb);
            }
            if (v < -128L) {
                return this.writeByteAndShort((byte)-47, (short)v, session, lb);
            }
            return this.writeByteAndByte((byte)-48, (byte)v, session, lb);
        }
        if (v < 128L) {
            return this.sink.writeByte((byte)v, session, lb);
        }
        if (v < 65536L) {
            if (v < 256L) {
                return this.writeByteAndByte((byte)-52, (byte)v, session, lb);
            }
            return this.writeByteAndShort((byte)-51, (short)v, session, lb);
        }
        if (v < 0x100000000L) {
            return this.writeByteAndInt((byte)-50, (int)v, session, lb);
        }
        return this.writeByteAndLong((byte)-49, v, session, lb);
    }

    public LinkedBuffer packFloat(float v, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeByteAndInt((byte)-54, Float.floatToRawIntBits(v), session, lb);
    }

    public LinkedBuffer packDouble(double v, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeByteAndLong((byte)-53, Double.doubleToRawLongBits(v), session, lb);
    }

    public LinkedBuffer packBoolean(boolean b, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.sink.writeByte(b ? (byte)-61 : -62, session, lb);
    }

    public LinkedBuffer packBinaryHeader(int len, WriteSession session, LinkedBuffer lb) throws IOException {
        if (len < 256) {
            return this.writeByteAndByte((byte)-60, (byte)len, session, lb);
        }
        if (len < 65536) {
            return this.writeByteAndShort((byte)-59, (short)len, session, lb);
        }
        return this.writeByteAndInt((byte)-58, len, session, lb);
    }

    public LinkedBuffer packRawStringHeader(int len, WriteSession session, LinkedBuffer lb) throws IOException {
        if (len < 32) {
            return this.sink.writeByte((byte)(0xFFFFFFA0 | len), session, lb);
        }
        if (this.str8FormatSupport && len < 256) {
            return this.writeByteAndByte((byte)-39, (byte)len, session, lb);
        }
        if (len < 65536) {
            return this.writeByteAndShort((byte)-38, (short)len, session, lb);
        }
        return this.writeByteAndInt((byte)-37, len, session, lb);
    }

    public LinkedBuffer packString(CharSequence value, WriteSession session, LinkedBuffer lb) throws IOException {
        if (value.length() == 0) {
            return this.packRawStringHeader(0, session, lb);
        }
        int sizeInBytes = StringSerializer.computeUTF8Size((CharSequence)value, (int)0, (int)value.length());
        return StringSerializer.writeUTF8((CharSequence)value, (WriteSession)session, (LinkedBuffer)this.packRawStringHeader(sizeInBytes, session, lb));
    }

    public LinkedBuffer packBytes(byte[] src, int offset, int length, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.sink.writeByteArray(src, offset, length, session, lb);
    }

    public LinkedBuffer packArrayHeader(int arraySize, WriteSession session, LinkedBuffer lb) throws IOException {
        if (arraySize < 0) {
            throw new IllegalArgumentException("array size must be >= 0");
        }
        if (arraySize < 16) {
            return this.sink.writeByte((byte)(0xFFFFFF90 | arraySize), session, lb);
        }
        if (arraySize < 65536) {
            return this.writeByteAndShort((byte)-36, (short)arraySize, session, lb);
        }
        return this.writeByteAndInt((byte)-35, arraySize, session, lb);
    }

    public LinkedBuffer packMapHeader(int mapSize, WriteSession session, LinkedBuffer lb) throws IOException {
        if (mapSize < 0) {
            throw new IllegalArgumentException("map size must be >= 0");
        }
        if (mapSize < 16) {
            return this.sink.writeByte((byte)(0xFFFFFF80 | mapSize), session, lb);
        }
        if (mapSize < 65536) {
            return this.writeByteAndShort((byte)-34, (short)mapSize, session, lb);
        }
        return this.writeByteAndInt((byte)-33, mapSize, session, lb);
    }
}

