/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Schema;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.core.MessageUnpacker;

public final class MsgpackParser {
    private final MessageUnpacker unpacker;
    private final boolean numeric;
    private int leftEntries = -1;
    private int leftItems;
    private int lastNumber;

    public MsgpackParser(MessageUnpacker unpacker, boolean numeric) throws IOException {
        this.unpacker = unpacker;
        this.numeric = numeric;
        this.reset();
    }

    public MsgpackParser(MsgpackParser parent) throws IOException {
        this.unpacker = parent.unpacker;
        this.numeric = parent.numeric;
        this.reset();
    }

    public boolean hasNext() throws IOException {
        return this.unpacker.hasNext();
    }

    public void reset() throws IOException {
        this.leftEntries = -1;
        this.leftItems = 0;
        this.lastNumber = 0;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public int getLeftEntries() {
        return this.leftEntries;
    }

    public int getLeftItems() {
        return this.leftItems;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public <T> int parseFieldNumber(Schema<T> schema) throws IOException {
        int fieldNumber;
        if (this.leftItems != 0) {
            --this.leftItems;
            return this.lastNumber;
        }
        if (this.leftEntries == -1) {
            if (!this.unpacker.hasNext()) {
                return 0;
            }
            this.leftEntries = this.unpacker.unpackMapHeader();
        }
        if (this.leftEntries == 0) {
            return 0;
        }
        --this.leftEntries;
        if (this.numeric) {
            fieldNumber = this.unpacker.unpackInt();
        } else {
            String name = this.unpacker.unpackString();
            fieldNumber = schema.getFieldNumber(name);
        }
        if (this.unpacker.hasNext() && this.unpacker.getNextFormat().getValueType().isArrayType()) {
            this.leftItems = this.unpacker.unpackArrayHeader();
            this.lastNumber = fieldNumber;
            if (this.leftItems == 0) {
                return this.parseFieldNumber(schema);
            }
            --this.leftItems;
        }
        return fieldNumber;
    }

    public void skipValue() throws IOException {
        this.unpacker.skipValue();
    }

    public int parseInt() throws IOException {
        return this.unpacker.unpackInt();
    }

    public long parseLong() throws IOException {
        return this.unpacker.unpackLong();
    }

    public float parseFloat() throws IOException {
        return this.unpacker.unpackFloat();
    }

    public double parseDouble() throws IOException {
        return this.unpacker.unpackDouble();
    }

    public boolean parseBoolean() throws IOException {
        return this.unpacker.unpackBoolean();
    }

    public String parseString() throws IOException {
        return this.unpacker.unpackString();
    }

    public byte[] parsePayload() throws IOException {
        int length = this.unpacker.unpackBinaryHeader();
        return this.unpacker.readPayload(length);
    }

    public ByteBuffer readPayload() throws IOException {
        int length = this.unpacker.unpackBinaryHeader();
        ByteBuffer buffer = ByteBuffer.allocate(length);
        this.unpacker.readPayload(buffer);
        return buffer;
    }
}

