/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteString;
import io.protostuff.MsgpackGenerator;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.value.ImmutableBooleanValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableBinaryValueImpl;
import org.msgpack.value.impl.ImmutableBooleanValueImpl;
import org.msgpack.value.impl.ImmutableDoubleValueImpl;
import org.msgpack.value.impl.ImmutableLongValueImpl;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public class MsgpackOutput
implements Output,
StatefulOutput {
    private MsgpackGenerator generator;
    private Schema<?> schema;

    public MsgpackOutput(MsgpackGenerator generator, Schema<?> schema) {
        this.generator = generator;
        this.schema = schema;
    }

    public void updateLast(Schema<?> schema, Schema<?> lastSchema) {
        if (lastSchema != null && lastSchema == this.schema) {
            this.schema = schema;
        }
    }

    public MsgpackOutput use(MsgpackGenerator generator, Schema<?> schema) {
        this.schema = schema;
        this.generator = generator;
        return this;
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl((long)value), repeated);
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl((long)value), repeated);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl((long)value), repeated);
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl((long)value), repeated);
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl((long)value), repeated);
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl(value), repeated);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl(value), repeated);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl(value), repeated);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl(value), repeated);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl(value), repeated);
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, new MsgpackGenerator.ImmutableFloatValueImpl(value), repeated);
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableDoubleValueImpl(value), repeated);
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        ImmutableBooleanValue val = value ? ImmutableBooleanValueImpl.TRUE : ImmutableBooleanValueImpl.FALSE;
        this.generator.pushValue(this.schema, fieldNumber, (Value)val, repeated);
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableLongValueImpl((long)value), repeated);
    }

    public void writeString(int fieldNumber, CharSequence value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableStringValueImpl(value.toString()), repeated);
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableBinaryValueImpl(value.getBytes()), repeated);
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableBinaryValueImpl(value), repeated);
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        byte[] copiedValue = new byte[length];
        System.arraycopy(value, offset, copiedValue, 0, length);
        if (utf8String) {
            this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableStringValueImpl(copiedValue), repeated);
        } else {
            this.generator.pushValue(this.schema, fieldNumber, (Value)new ImmutableBinaryValueImpl(copiedValue), repeated);
        }
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> innerSchema, boolean repeated) throws IOException {
        MsgpackGenerator innerGenerator = new MsgpackGenerator(this.generator.isNumeric());
        MsgpackGenerator thisGenerator = this.generator;
        Schema<?> thisSchema = this.schema;
        this.use(innerGenerator, innerSchema);
        innerSchema.writeTo((Output)this, value);
        this.use(thisGenerator, thisSchema);
        this.generator.pushValue(this.schema, fieldNumber, (Value)innerGenerator.toValue(), repeated);
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated);
    }
}

