/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteString;
import io.protostuff.LinkedBuffer;
import io.protostuff.MsgpackWriteSink;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import io.protostuff.WriteSession;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MsgpackXOutput
extends WriteSession
implements Output,
StatefulOutput {
    public static final int MAX_MAPHEADER_SIZE = 5;
    public static final int MAX_ARRAYHEADER_SIZE = 5;
    private Schema<?> schema;
    private final boolean numeric;
    private LinkedBuffer arrayHeader;
    private boolean lastRepeated;
    private int lastNumber;
    private int arraySize;
    private int mapSize;
    private MsgpackWriteSink packSink;

    public MsgpackXOutput(LinkedBuffer head, boolean numeric, Schema<?> schema) {
        super(head);
        this.numeric = numeric;
        this.schema = schema;
        this.packSink = new MsgpackWriteSink(this.sink, true);
    }

    public LinkedBuffer writeStartObject() {
        if (this.tail.buffer.length - this.tail.offset < 5) {
            this.tail = new LinkedBuffer(this.nextBufferSize, this.tail);
        }
        LinkedBuffer objectHeader = this.tail;
        objectHeader.next = this.tail = LinkedBuffer.wrap((byte[])this.tail.buffer, (int)(this.tail.offset + 5), (int)0);
        return objectHeader;
    }

    public void writeEndObject(LinkedBuffer lb) throws IOException {
        this.packSink.packMapHeader(this.mapSize, this, lb);
    }

    private void writeStartArray() {
        if (this.tail.buffer.length - this.tail.offset < 5) {
            this.tail = new LinkedBuffer(this.nextBufferSize, this.tail);
        }
        this.arrayHeader = this.tail;
        this.arrayHeader.next = this.tail = LinkedBuffer.wrap((byte[])this.tail.buffer, (int)(this.tail.offset + 5), (int)0);
        this.arraySize = 1;
    }

    public void writeEndArray() throws IOException {
        this.packSink.packArrayHeader(this.arraySize, this, this.arrayHeader);
    }

    public void reset() {
        this.arrayHeader = null;
        this.lastRepeated = false;
        this.lastNumber = 0;
        this.arraySize = 0;
        this.mapSize = 0;
    }

    public MsgpackXOutput clear() {
        super.clear();
        this.reset();
        return this;
    }

    public MsgpackXOutput use(Schema<?> schema) {
        this.schema = schema;
        return this;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public boolean isLastRepeated() {
        return this.lastRepeated;
    }

    public void updateLast(Schema<?> schema, Schema<?> lastSchema) {
        if (lastSchema != null && lastSchema == this.schema) {
            this.schema = schema;
        }
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt(fieldNumber, value, repeated);
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt(fieldNumber, value, repeated);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt(fieldNumber, value, repeated);
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt(fieldNumber, value, repeated);
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt(fieldNumber, value, repeated);
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeLong(fieldNumber, value, repeated);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeLong(fieldNumber, value, repeated);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeLong(fieldNumber, value, repeated);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeLong(fieldNumber, value, repeated);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeLong(fieldNumber, value, repeated);
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt(fieldNumber, value, repeated);
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeBytes(fieldNumber, value.getBytes(), 0, value.size(), repeated, false);
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        this.writeBytes(fieldNumber, value, 0, value.length, repeated, false);
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        this.writeBytes(fieldNumber, value, offset, length, repeated, utf8String);
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.writeSingleObject(fieldNumber, value, schema);
            ++this.arraySize;
            return;
        }
        if (this.lastRepeated) {
            this.writeEndArray();
        }
        this.writeFieldNumber(fieldNumber);
        if (repeated) {
            this.writeStartArray();
        }
        this.writeSingleObject(fieldNumber, value, schema);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    private <T> void writeSingleObject(int fieldNumber, T value, Schema<T> schema) throws IOException {
        Schema<?> lastSchema = this.schema;
        int lastMapSize = this.mapSize;
        int lastArraySize = this.arraySize;
        boolean saveLastRepeated = this.lastRepeated;
        LinkedBuffer lastArrayHeader = this.arrayHeader;
        this.reset();
        this.use(schema);
        LinkedBuffer objectHeader = this.writeStartObject();
        schema.writeTo((Output)this, value);
        if (this.isLastRepeated()) {
            this.writeEndArray();
        }
        this.writeEndObject(objectHeader);
        this.schema = lastSchema;
        this.mapSize = lastMapSize;
        this.arraySize = lastArraySize;
        this.arrayHeader = lastArrayHeader;
        this.lastRepeated = saveLastRepeated;
        this.lastNumber = fieldNumber;
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeBytes(fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated, false);
    }

    private void writeInt(int fieldNumber, int value, boolean repeated) throws IOException {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.tail = this.packSink.packInt(value, this, this.tail);
            ++this.arraySize;
            return;
        }
        if (this.lastRepeated) {
            this.writeEndArray();
        }
        this.writeFieldNumber(fieldNumber);
        if (repeated) {
            this.writeStartArray();
        }
        this.tail = this.packSink.packInt(value, this, this.tail);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    private void writeLong(int fieldNumber, long value, boolean repeated) throws IOException {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.tail = this.packSink.packLong(value, this, this.tail);
            ++this.arraySize;
            return;
        }
        if (this.lastRepeated) {
            this.writeEndArray();
        }
        this.writeFieldNumber(fieldNumber);
        if (repeated) {
            this.writeStartArray();
        }
        this.tail = this.packSink.packLong(value, this, this.tail);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.tail = this.packSink.packFloat(value, this, this.tail);
            ++this.arraySize;
            return;
        }
        if (this.lastRepeated) {
            this.writeEndArray();
        }
        this.writeFieldNumber(fieldNumber);
        if (repeated) {
            this.writeStartArray();
        }
        this.tail = this.packSink.packFloat(value, this, this.tail);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.tail = this.packSink.packDouble(value, this, this.tail);
            ++this.arraySize;
            return;
        }
        if (this.lastRepeated) {
            this.writeEndArray();
        }
        this.writeFieldNumber(fieldNumber);
        if (repeated) {
            this.writeStartArray();
        }
        this.tail = this.packSink.packDouble(value, this, this.tail);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.tail = this.packSink.packBoolean(value, this, this.tail);
            ++this.arraySize;
            return;
        }
        if (this.lastRepeated) {
            this.writeEndArray();
        }
        this.writeFieldNumber(fieldNumber);
        if (repeated) {
            this.writeStartArray();
        }
        this.tail = this.packSink.packBoolean(value, this, this.tail);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeString(int fieldNumber, CharSequence value, boolean repeated) throws IOException {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.tail = this.packSink.packString(value, this, this.tail);
            ++this.arraySize;
            return;
        }
        if (this.lastRepeated) {
            this.writeEndArray();
        }
        this.writeFieldNumber(fieldNumber);
        if (repeated) {
            this.writeStartArray();
        }
        this.tail = this.packSink.packString(value, this, this.tail);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    private void writeBytes(int fieldNumber, byte[] src, int offset, int length, boolean repeated, boolean utf8) throws IOException {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.tail = this.packSink.packBinaryHeader(length, this, this.tail);
            this.tail = this.packSink.packBytes(src, offset, length, this, this.tail);
            ++this.arraySize;
            return;
        }
        if (this.lastRepeated) {
            this.writeEndArray();
        }
        this.writeFieldNumber(fieldNumber);
        if (repeated) {
            this.writeStartArray();
        }
        this.tail = this.packSink.packBinaryHeader(length, this, this.tail);
        this.tail = this.packSink.packBytes(src, offset, length, this, this.tail);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    private void writeFieldNumber(int fieldNumber) throws IOException {
        if (this.numeric) {
            this.tail = this.packSink.packInt(fieldNumber, this, this.tail);
        } else {
            String fieldName = this.schema.getFieldName(fieldNumber);
            this.tail = this.packSink.packString(fieldName, this, this.tail);
        }
        ++this.mapSize;
    }
}

