/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteString;
import io.protostuff.Input;
import io.protostuff.MsgpackParser;
import io.protostuff.Output;
import io.protostuff.Schema;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MsgpackInput
implements Input {
    private MsgpackParser parser;

    public MsgpackInput(MsgpackParser parser) {
        this.parser = parser;
    }

    public MsgpackParser use(MsgpackParser newParser) {
        MsgpackParser old = this.parser;
        this.parser = newParser;
        return old;
    }

    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        this.parser.skipValue();
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        return this.parser.parseFieldNumber(schema);
    }

    public int readInt32() throws IOException {
        return this.parser.parseInt();
    }

    public int readUInt32() throws IOException {
        return this.parser.parseInt();
    }

    public int readSInt32() throws IOException {
        return this.parser.parseInt();
    }

    public int readFixed32() throws IOException {
        return this.parser.parseInt();
    }

    public int readSFixed32() throws IOException {
        return this.parser.parseInt();
    }

    public long readInt64() throws IOException {
        return this.parser.parseLong();
    }

    public long readUInt64() throws IOException {
        return this.parser.parseLong();
    }

    public long readSInt64() throws IOException {
        return this.parser.parseLong();
    }

    public long readFixed64() throws IOException {
        return this.parser.parseLong();
    }

    public long readSFixed64() throws IOException {
        return this.parser.parseLong();
    }

    public float readFloat() throws IOException {
        return this.parser.parseFloat();
    }

    public double readDouble() throws IOException {
        return this.parser.parseDouble();
    }

    public boolean readBool() throws IOException {
        return this.parser.parseBoolean();
    }

    public int readEnum() throws IOException {
        return this.parser.parseInt();
    }

    public String readString() throws IOException {
        return this.parser.parseString();
    }

    public ByteString readBytes() throws IOException {
        return ByteString.wrap((byte[])this.parser.parsePayload());
    }

    public byte[] readByteArray() throws IOException {
        return this.parser.parsePayload();
    }

    public ByteBuffer readByteBuffer() throws IOException {
        return this.parser.readPayload();
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (value == null) {
            value = schema.newMessage();
        }
        MsgpackParser innerParser = new MsgpackParser(this.parser);
        MsgpackParser thisParser = this.use(innerParser);
        schema.mergeFrom((Input)this, value);
        this.use(thisParser);
        return value;
    }

    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        if (utf8String) {
            output.writeString(fieldNumber, (CharSequence)this.readString(), repeated);
        } else {
            output.writeByteArray(fieldNumber, this.readByteArray(), repeated);
        }
    }

    public void readBytes(ByteBuffer bb) throws IOException {
        bb.put(this.parser.parsePayload());
    }
}

