/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Input;
import io.protostuff.MsgpackGenerator;
import io.protostuff.MsgpackInput;
import io.protostuff.MsgpackOutput;
import io.protostuff.MsgpackParser;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.ArrayBufferOutput;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.core.buffer.MessageBufferOutput;

public final class MsgpackIOUtil {
    public static final int END_OF_OBJECT = 0;

    private MsgpackIOUtil() {
    }

    public static Pipe newPipe(byte[] data, boolean numeric) throws IOException {
        return MsgpackIOUtil.newPipe(data, 0, data.length, numeric);
    }

    public static Pipe newPipe(byte[] data, int offset, int length, boolean numeric) throws IOException {
        ArrayBufferInput in = new ArrayBufferInput(data, offset, length);
        return MsgpackIOUtil.newPipe((MessageBufferInput)in, numeric);
    }

    public static Pipe newPipe(MessageBufferInput in, boolean numeric) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)in);
        return MsgpackIOUtil.newPipe(unpacker, numeric);
    }

    public static Pipe newPipe(InputStream in, boolean numeric) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((InputStream)in);
        return MsgpackIOUtil.newPipe(unpacker, numeric);
    }

    public static Pipe newPipe(final MessageUnpacker unpacker, boolean numeric) throws IOException {
        MsgpackParser parser = new MsgpackParser(unpacker, numeric);
        final MsgpackInput msgpackInput = new MsgpackInput(parser);
        return new Pipe(){

            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                return msgpackInput;
            }

            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    unpacker.close();
                    return;
                }
                assert (input == msgpackInput);
                unpacker.close();
            }
        };
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema, boolean numeric) throws IOException {
        MsgpackIOUtil.mergeFrom(data, 0, data.length, message, schema, numeric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema, boolean numeric) throws IOException {
        ArrayBufferInput bios = new ArrayBufferInput(data, offset, length);
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)bios);
        try {
            MsgpackIOUtil.mergeFrom(unpacker, message, schema, numeric);
        }
        finally {
            unpacker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(MessageBufferInput in, T message, Schema<T> schema, boolean numeric) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)in);
        try {
            MsgpackIOUtil.mergeFrom(unpacker, message, schema, numeric);
        }
        finally {
            unpacker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean numeric) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((InputStream)in);
        try {
            MsgpackIOUtil.mergeFrom(unpacker, message, schema, numeric);
        }
        finally {
            unpacker.close();
        }
    }

    public static <T> void mergeFrom(MessageUnpacker unpacker, T message, Schema<T> schema, boolean numeric) throws IOException {
        MsgpackParser parser = new MsgpackParser(unpacker, numeric);
        schema.mergeFrom((Input)new MsgpackInput(parser), message);
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric) {
        ArrayBufferOutput out = new ArrayBufferOutput();
        try {
            MsgpackIOUtil.writeTo((MessageBufferOutput)out, message, schema, numeric);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException", e);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeTo(MessageBufferOutput out, T message, Schema<T> schema, boolean numeric) throws IOException {
        MessagePacker packer = MessagePack.newDefaultPacker((MessageBufferOutput)out);
        try {
            MsgpackIOUtil.writeTo(packer, message, schema, numeric);
        }
        finally {
            packer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric) throws IOException {
        MessagePacker packer = MessagePack.newDefaultPacker((OutputStream)out);
        try {
            MsgpackIOUtil.writeTo(packer, message, schema, numeric);
        }
        finally {
            packer.flush();
        }
    }

    public static <T> void writeTo(MessagePacker packer, T message, Schema<T> schema, boolean numeric) throws IOException {
        MsgpackGenerator generator = new MsgpackGenerator(numeric);
        MsgpackOutput output = new MsgpackOutput(generator, schema);
        schema.writeTo((Output)output, message);
        generator.writeTo(packer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        MessagePacker packer = MessagePack.newDefaultPacker((OutputStream)out);
        try {
            MsgpackIOUtil.writeListTo(packer, messages, schema, numeric);
        }
        finally {
            packer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeListTo(MessageBufferOutput out, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        MessagePacker packer = MessagePack.newDefaultPacker((MessageBufferOutput)out);
        try {
            MsgpackIOUtil.writeListTo(packer, messages, schema, numeric);
        }
        finally {
            packer.flush();
        }
    }

    public static <T> void writeListTo(MessagePacker packer, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        MsgpackGenerator generator = new MsgpackGenerator(numeric);
        MsgpackOutput output = new MsgpackOutput(generator, schema);
        for (T m : messages) {
            schema.writeTo((Output)output, m);
            generator.writeTo(packer);
            generator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parseListFrom(MessageBufferInput in, Schema<T> schema, boolean numeric) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)in);
        try {
            List<T> list = MsgpackIOUtil.parseListFrom(unpacker, schema, numeric);
            return list;
        }
        finally {
            unpacker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema, boolean numeric) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((InputStream)in);
        try {
            List<T> list = MsgpackIOUtil.parseListFrom(unpacker, schema, numeric);
            return list;
        }
        finally {
            unpacker.close();
        }
    }

    public static <T> List<T> parseListFrom(MessageUnpacker unpacker, Schema<T> schema, boolean numeric) throws IOException {
        MsgpackParser parser = new MsgpackParser(unpacker, numeric);
        MsgpackInput input = new MsgpackInput(parser);
        ArrayList<Object> list = new ArrayList<Object>();
        while (parser.hasNext()) {
            Object message = schema.newMessage();
            schema.mergeFrom((Input)input, message);
            list.add(message);
            parser.reset();
        }
        return list;
    }
}

