/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageTypeCastException;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableArrayValue;
import org.msgpack.value.ImmutableBinaryValue;
import org.msgpack.value.ImmutableBooleanValue;
import org.msgpack.value.ImmutableExtensionValue;
import org.msgpack.value.ImmutableFloatValue;
import org.msgpack.value.ImmutableIntegerValue;
import org.msgpack.value.ImmutableMapValue;
import org.msgpack.value.ImmutableNilValue;
import org.msgpack.value.ImmutableNumberValue;
import org.msgpack.value.ImmutableRawValue;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;
import org.msgpack.value.impl.ImmutableArrayValueImpl;
import org.msgpack.value.impl.ImmutableLongValueImpl;
import org.msgpack.value.impl.ImmutableMapValueImpl;
import org.msgpack.value.impl.ImmutableNilValueImpl;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public final class MsgpackGenerator {
    private final List<Value> kvs = new ArrayList<Value>();
    private final boolean numeric;
    private boolean lastRepeated;
    private int lastNumber;

    public MsgpackGenerator(boolean numeric) {
        this.numeric = numeric;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isLastRepeated() {
        return this.lastRepeated;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public MsgpackGenerator reset() {
        this.kvs.clear();
        this.lastRepeated = false;
        this.lastNumber = 0;
        return this;
    }

    private ArrayValueImpl getLastArray() {
        return (ArrayValueImpl)this.kvs.get(this.kvs.size() - 1);
    }

    public void pushValue(Schema<?> schema, int fieldNumber, Value value, boolean repeated) {
        if (this.lastNumber == fieldNumber && this.lastRepeated) {
            this.getLastArray().add(value);
            return;
        }
        if (this.numeric) {
            this.kvs.add((Value)new ImmutableLongValueImpl((long)fieldNumber));
        } else {
            this.kvs.add((Value)new ImmutableStringValueImpl(schema.getFieldName(fieldNumber)));
        }
        if (repeated) {
            ArrayValueImpl array = new ArrayValueImpl();
            array.add(value);
            this.kvs.add(array);
        } else {
            this.kvs.add(value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeTo(MessagePacker packer) throws IOException {
        this.toValue().writeTo(packer);
    }

    public ImmutableMapValue toValue() {
        return new ImmutableMapValueImpl(this.kvs.toArray(new Value[this.kvs.size()]));
    }

    public static final class ImmutableFloatValueImpl
    extends AbstractValue
    implements ImmutableFloatValue {
        private final float value;

        public ImmutableFloatValueImpl(float value) {
            this.value = value;
        }

        public ValueType getValueType() {
            return ValueType.FLOAT;
        }

        public ImmutableFloatValueImpl immutableValue() {
            return this;
        }

        @Override
        public ImmutableNumberValue asNumberValue() {
            return this;
        }

        @Override
        public ImmutableFloatValue asFloatValue() {
            return this;
        }

        public byte toByte() {
            return (byte)this.value;
        }

        public short toShort() {
            return (short)this.value;
        }

        public int toInt() {
            return (int)this.value;
        }

        public long toLong() {
            return (long)this.value;
        }

        public BigInteger toBigInteger() {
            return new BigDecimal(this.value).toBigInteger();
        }

        public float toFloat() {
            return this.value;
        }

        public double toDouble() {
            return this.value;
        }

        public void writeTo(MessagePacker pk) throws IOException {
            pk.packFloat(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value v = (Value)o;
            if (!v.isFloatValue()) {
                return false;
            }
            return this.value == v.asFloatValue().toFloat();
        }

        public int hashCode() {
            int v = Float.floatToIntBits(this.value);
            return v ^ v >>> 32;
        }

        public String toJson() {
            if (Float.isNaN(this.value) || Float.isInfinite(this.value)) {
                return "null";
            }
            return Float.toString(this.value);
        }

        public String toString() {
            return Float.toString(this.value);
        }
    }

    public static final class ArrayValueImpl
    extends AbstractValue
    implements ArrayValue {
        private final List<Value> list = new ArrayList<Value>();

        public void reset() {
            this.list.clear();
        }

        public void add(Value value) {
            this.list.add(value);
        }

        public ImmutableValue immutableValue() {
            return new ImmutableArrayValueImpl(this.list.toArray(new Value[this.list.size()]));
        }

        public void writeTo(MessagePacker packer) throws IOException {
            int size = this.list.size();
            packer.packArrayHeader(size);
            for (int i = 0; i != size; ++i) {
                this.list.get(i).writeTo(packer);
            }
        }

        public String toJson() {
            int size = this.list.size();
            if (size == 0) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(this.list.get(0).toJson());
            for (int i = 1; i != size; ++i) {
                sb.append(",");
                sb.append(this.list.get(0).toJson());
            }
            sb.append("]");
            return sb.toString();
        }

        public String toString() {
            int size = this.list.size();
            if (size == 0) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            this.appendString(sb, this.list.get(0));
            for (int i = 1; i != size; ++i) {
                sb.append(",");
                this.appendString(sb, this.list.get(i));
            }
            sb.append("]");
            return sb.toString();
        }

        private void appendString(StringBuilder sb, Value value) {
            if (value.isRawValue()) {
                sb.append(value.toJson());
            } else {
                sb.append(value.toString());
            }
        }

        public int size() {
            return this.list.size();
        }

        public Value get(int index) {
            return this.list.get(index);
        }

        public Value getOrNilValue(int index) {
            if (index < this.list.size() && index >= 0) {
                return this.list.get(index);
            }
            return ImmutableNilValueImpl.get();
        }

        public Iterator<Value> iterator() {
            return this.list.iterator();
        }

        public List<Value> list() {
            return this.list;
        }

        public ValueType getValueType() {
            return ValueType.ARRAY;
        }
    }

    public static abstract class AbstractValue
    implements Value {
        public boolean isNilValue() {
            return this.getValueType().isNilType();
        }

        public boolean isBooleanValue() {
            return this.getValueType().isBooleanType();
        }

        public boolean isNumberValue() {
            return this.getValueType().isNumberType();
        }

        public boolean isIntegerValue() {
            return this.getValueType().isIntegerType();
        }

        public boolean isFloatValue() {
            return this.getValueType().isFloatType();
        }

        public boolean isRawValue() {
            return this.getValueType().isRawType();
        }

        public boolean isBinaryValue() {
            return this.getValueType().isBinaryType();
        }

        public boolean isStringValue() {
            return this.getValueType().isStringType();
        }

        public boolean isArrayValue() {
            return this.getValueType().isArrayType();
        }

        public boolean isMapValue() {
            return this.getValueType().isMapType();
        }

        public boolean isExtensionValue() {
            return this.getValueType().isExtensionType();
        }

        public ImmutableNilValue asNilValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableBooleanValue asBooleanValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableNumberValue asNumberValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableIntegerValue asIntegerValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableFloatValue asFloatValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableRawValue asRawValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableBinaryValue asBinaryValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableStringValue asStringValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableArrayValue asArrayValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableMapValue asMapValue() {
            throw new MessageTypeCastException();
        }

        public ImmutableExtensionValue asExtensionValue() {
            throw new MessageTypeCastException();
        }
    }
}

