/*
 * Decompiled with CFR 0.152.
 */
package com.tealcube.minecraft.spigot.worldguard.adapters.v62x;

import com.sk89q.worldguard.bukkit.RegionContainer;
import com.sk89q.worldguard.bukkit.RegionQuery;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.tealcube.minecraft.spigot.worldguard.adapters.IWorldGuardAdapter;
import com.tealcube.minecraft.spigot.worldguard.adapters.v62x.WorldGuardAdapter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\b\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/tealcube/minecraft/spigot/worldguard/adapters/v62x/WorldGuardAdapter;", "Lcom/tealcube/minecraft/spigot/worldguard/adapters/IWorldGuardAdapter;", "()V", "flagRegistry", "Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;", "getFlagRegistry", "()Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;", "flagRegistry$delegate", "Lkotlin/Lazy;", "nullPlayer", "Lorg/bukkit/entity/Player;", "regionContainer", "Lcom/sk89q/worldguard/bukkit/RegionContainer;", "getRegionContainer", "()Lcom/sk89q/worldguard/bukkit/RegionContainer;", "regionContainer$delegate", "getFlagFromRegistry", "Lcom/sk89q/worldguard/protection/flags/StateFlag;", "flagName", "", "getRegionQuery", "Lcom/sk89q/worldguard/bukkit/RegionQuery;", "kotlin.jvm.PlatformType", "isFlagAllowAtLocation", "", "location", "Lorg/bukkit/Location;", "flag", "isFlagDenyAtLocation", "registerFlag", "", "adapter-6.2.x"})
public final class WorldGuardAdapter
implements IWorldGuardAdapter {
    @NotNull
    public static final WorldGuardAdapter INSTANCE = new WorldGuardAdapter();
    @Nullable
    private static final Player nullPlayer;
    @NotNull
    private static final Lazy regionContainer$delegate;
    @NotNull
    private static final Lazy flagRegistry$delegate;

    private WorldGuardAdapter() {
    }

    private final RegionContainer getRegionContainer() {
        Lazy lazy = regionContainer$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"is file is part of WorldGuard Adapters, licensed under the MIT License.\n *\n * Copyright (C) 2019 Richard Harrah\n *\n * Permission is hereby granted, free of charge,\n * to any person obtaining a copy of this software and associated documentation files (the \"Software\"),\n * to deal in the Software without restriction, including without limitation the rights to use,\n * copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,\n * and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in all copies or\n * substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,\n * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS\n * OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\n * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\n * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n */\npackage com.tealcube.minecraft.spigot.worldguard.adapters.v62x\n\nimport com.sk89q.worldguard.bukkit.RegionContainer\nimport com.sk89q.worldguard.bukkit.WGBukkit\nimport com.sk89q.worldguard.protection.flags.StateFlag\nimport com.sk89q.worldguard.protection.flags.registry.FlagRegistry\nimport com.tealcube.minecraft.spigot.worldguard.adapters.IWorldGuardAdapter\nimport org.bukkit.Location\nimport org.bukkit.entity.Player\n\nobject WorldGuardAdapter : IWorldGuardAdapter {\n    private val nullPlayer: Player? = null\n    private val regionContainer: RegionContainer by lazy {\n        WGBukkit.getPlugin().regionContainer\n    }");
        return (RegionContainer)object;
    }

    private final FlagRegistry getFlagRegistry() {
        Lazy lazy = flagRegistry$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"is file is part of WorldGuard Adapters, licensed under the MIT License.\n *\n * Copyright (C) 2019 Richard Harrah\n *\n * Permission is hereby granted, free of charge,\n * to any person obtaining a copy of this software and associated documentation files (the \"Software\"),\n * to deal in the Software without restriction, including without limitation the rights to use,\n * copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,\n * and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in all copies or\n * substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,\n * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS\n * OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\n * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\n * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n */\npackage com.tealcube.minecraft.spigot.worldguard.adapters.v62x\n\nimport com.sk89q.worldguard.bukkit.RegionContainer\nimport com.sk89q.worldguard.bukkit.WGBukkit\nimport com.sk89q.worldguard.protection.flags.StateFlag\nimport com.sk89q.worldguard.protection.flags.registry.FlagRegistry\nimport com.tealcube.minecraft.spigot.worldguard.adapters.IWorldGuardAdapter\nimport org.bukkit.Location\nimport org.bukkit.entity.Player\n\nobject WorldGuardAdapter : IWorldGuardAdapter {\n    private val nullPlayer: Player? = null\n    private val regionContainer: RegionContainer by lazy {\n        WGBukkit.getPlugin().regionContainer\n    }\n    private val flagRegistry: FlagRegistry by lazy {\n        WGBukkit.getPlugin().flagRegistry\n    }");
        return (FlagRegistry)object;
    }

    public boolean isFlagAllowAtLocation(@NotNull Location location, @NotNull String flagName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)flagName, (String)"flagName");
        StateFlag stateFlag = this.getFlagFromRegistry(flagName);
        if (stateFlag == null) {
            bl = true;
        } else {
            boolean bl2;
            StateFlag stateFlag2 = stateFlag;
            boolean bl3 = false;
            boolean bl4 = false;
            StateFlag it = stateFlag2;
            boolean bl5 = false;
            bl = bl2 = INSTANCE.isFlagAllowAtLocation(location, it);
        }
        return bl;
    }

    public boolean isFlagDenyAtLocation(@NotNull Location location, @NotNull String flagName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)flagName, (String)"flagName");
        StateFlag stateFlag = this.getFlagFromRegistry(flagName);
        if (stateFlag == null) {
            bl = false;
        } else {
            boolean bl2;
            StateFlag stateFlag2 = stateFlag;
            boolean bl3 = false;
            boolean bl4 = false;
            StateFlag it = stateFlag2;
            boolean bl5 = false;
            bl = bl2 = INSTANCE.isFlagDenyAtLocation(location, it);
        }
        return bl;
    }

    public void registerFlag(@NotNull String flagName) {
        Intrinsics.checkNotNullParameter((Object)flagName, (String)"flagName");
        this.getFlagRegistry().register((Flag)new StateFlag(flagName, true));
    }

    private final RegionQuery getRegionQuery() {
        return this.getRegionContainer().createQuery();
    }

    private final boolean isFlagAllowAtLocation(Location location, StateFlag flag) {
        StateFlag[] stateFlagArray = new StateFlag[]{flag};
        return this.getRegionQuery().testState(location, nullPlayer, stateFlagArray);
    }

    private final boolean isFlagDenyAtLocation(Location location, StateFlag flag) {
        StateFlag[] stateFlagArray = new StateFlag[]{flag};
        return !this.getRegionQuery().testState(location, nullPlayer, stateFlagArray);
    }

    private final StateFlag getFlagFromRegistry(String flagName) {
        Flag flag = this.getFlagRegistry().get(flagName);
        return flag instanceof StateFlag ? (StateFlag)flag : null;
    }

    static {
        regionContainer$delegate = LazyKt.lazy((Function0)regionContainer.2.INSTANCE);
        flagRegistry$delegate = LazyKt.lazy((Function0)flagRegistry.2.INSTANCE);
    }
}

