/*
 * Decompiled with CFR 0.152.
 */
package io.pixeloutlaw.minecraft.spigot.plumbing.lib;

import io.pixeloutlaw.minecraft.spigot.plumbing.api.AbstractItemAttributes;
import io.pixeloutlaw.minecraft.spigot.plumbing.lib.ItemAttributes;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.attribute.Attribute;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0003\u0010\u0005R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\u0007\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lio/pixeloutlaw/minecraft/spigot/plumbing/lib/ItemAttributes;", "", "()V", "isSupportedBukkitVersion", "", "()Z", "isSupportedBukkitVersion$delegate", "Lkotlin/Lazy;", "itemAttributesByServer", "Lio/pixeloutlaw/minecraft/spigot/plumbing/api/AbstractItemAttributes;", "getItemAttributesByServer", "()Lio/pixeloutlaw/minecraft/spigot/plumbing/api/AbstractItemAttributes;", "itemAttributesByServer$delegate", "cloneWithDefaultAttributes", "Lorg/bukkit/inventory/ItemStack;", "itemStack", "conditionallyCloneWithDefaultAttributes", "NoOpItemAttributes", "plumbing-lib"})
public final class ItemAttributes {
    @NotNull
    public static final ItemAttributes INSTANCE = new ItemAttributes();
    @NotNull
    private static final Lazy itemAttributesByServer$delegate = LazyKt.lazy((Function0)itemAttributesByServer.2.INSTANCE);
    @NotNull
    private static final Lazy isSupportedBukkitVersion$delegate = LazyKt.lazy((Function0)isSupportedBukkitVersion.2.INSTANCE);

    private ItemAttributes() {
    }

    private final AbstractItemAttributes getItemAttributesByServer() {
        Lazy lazy = itemAttributesByServer$delegate;
        return (AbstractItemAttributes)lazy.getValue();
    }

    public final boolean isSupportedBukkitVersion() {
        Lazy lazy = isSupportedBukkitVersion$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final ItemStack conditionallyCloneWithDefaultAttributes(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        ItemMeta itemMeta = itemStack.getItemMeta();
        boolean bl = itemMeta != null ? itemMeta.hasAttributeModifiers() : false;
        if (bl) {
            ItemStack itemStack2 = itemStack.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"itemStack.clone()");
            return itemStack2;
        }
        return this.cloneWithDefaultAttributes(itemStack);
    }

    @NotNull
    public final ItemStack cloneWithDefaultAttributes(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (!this.isSupportedBukkitVersion()) {
            ItemStack itemStack2 = itemStack.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"itemStack.clone()");
            return itemStack2;
        }
        return this.getItemAttributesByServer().cloneWithDefaultAttributes(itemStack);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/pixeloutlaw/minecraft/spigot/plumbing/lib/ItemAttributes$NoOpItemAttributes;", "Lio/pixeloutlaw/minecraft/spigot/plumbing/api/AbstractItemAttributes;", "()V", "availableAttributes", "", "Lorg/bukkit/attribute/Attribute;", "getAvailableAttributes", "()Ljava/util/List;", "availableEquipmentSlots", "Lorg/bukkit/inventory/EquipmentSlot;", "getAvailableEquipmentSlots", "handleEquipmentSlot", "", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "slot", "itemMeta", "Lorg/bukkit/inventory/meta/ItemMeta;", "plumbing-lib"})
    public static final class NoOpItemAttributes
    extends AbstractItemAttributes {
        @NotNull
        public static final NoOpItemAttributes INSTANCE = new NoOpItemAttributes();
        @NotNull
        private static final List<Attribute> availableAttributes = CollectionsKt.emptyList();
        @NotNull
        private static final List<EquipmentSlot> availableEquipmentSlots = CollectionsKt.emptyList();

        private NoOpItemAttributes() {
        }

        @NotNull
        public List<Attribute> getAvailableAttributes() {
            return availableAttributes;
        }

        @NotNull
        public List<EquipmentSlot> getAvailableEquipmentSlots() {
            return availableEquipmentSlots;
        }

        public void handleEquipmentSlot(@NotNull ItemStack itemStack, @NotNull EquipmentSlot slot, @NotNull ItemMeta itemMeta) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
            Intrinsics.checkNotNullParameter((Object)itemMeta, (String)"itemMeta");
        }
    }
}

