/*
 * Decompiled with CFR 0.152.
 */
package io.pixeloutlaw.minecraft.spigot.plumbing.lib;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.pixeloutlaw.minecraft.spigot.plumbing.api.AbstractItemAttributes;
import io.pixeloutlaw.minecraft.spigot.plumbing.lib.ItemAttributes;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\n\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\t\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lio/pixeloutlaw/minecraft/spigot/plumbing/lib/ItemAttributes;", "", "()V", "availableEquipmentSlots", "", "Lorg/bukkit/inventory/EquipmentSlot;", "getAvailableEquipmentSlots", "()[Lorg/bukkit/inventory/EquipmentSlot;", "availableEquipmentSlots$delegate", "Lkotlin/Lazy;", "isSupportedBukkitVersion", "", "()Z", "isSupportedBukkitVersion$delegate", "itemAttributesByServer", "Lio/pixeloutlaw/minecraft/spigot/plumbing/api/AbstractItemAttributes;", "getItemAttributesByServer", "()Lio/pixeloutlaw/minecraft/spigot/plumbing/api/AbstractItemAttributes;", "itemAttributesByServer$delegate", "getDefaultItemAttributes", "Lcom/google/common/collect/Multimap;", "Lorg/bukkit/attribute/Attribute;", "Lorg/bukkit/attribute/AttributeModifier;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "equipmentSlot", "NoOpItemAttributes", "plumbing-lib"})
public final class ItemAttributes {
    @NotNull
    public static final ItemAttributes INSTANCE = new ItemAttributes();
    @NotNull
    private static final Lazy availableEquipmentSlots$delegate = LazyKt.lazy((Function0)availableEquipmentSlots.2.INSTANCE);
    @NotNull
    private static final Lazy itemAttributesByServer$delegate = LazyKt.lazy((Function0)itemAttributesByServer.2.INSTANCE);
    @NotNull
    private static final Lazy isSupportedBukkitVersion$delegate = LazyKt.lazy((Function0)isSupportedBukkitVersion.2.INSTANCE);

    private ItemAttributes() {
    }

    private final EquipmentSlot[] getAvailableEquipmentSlots() {
        Lazy lazy = availableEquipmentSlots$delegate;
        boolean bl = false;
        return (EquipmentSlot[])lazy.getValue();
    }

    private final AbstractItemAttributes getItemAttributesByServer() {
        Lazy lazy = itemAttributesByServer$delegate;
        boolean bl = false;
        return (AbstractItemAttributes)lazy.getValue();
    }

    public final boolean isSupportedBukkitVersion() {
        Lazy lazy = isSupportedBukkitVersion$delegate;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Multimap<Attribute, AttributeModifier> getDefaultItemAttributes(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        HashMultimap results = HashMultimap.create();
        EquipmentSlot[] $this$forEach$iv = this.getAvailableEquipmentSlots();
        boolean $i$f$forEach = false;
        EquipmentSlot[] equipmentSlotArray = $this$forEach$iv;
        int n = equipmentSlotArray.length;
        for (int i = 0; i < n; ++i) {
            EquipmentSlot element$iv;
            EquipmentSlot slot = element$iv = equipmentSlotArray[i];
            boolean bl = false;
            results.putAll(INSTANCE.getDefaultItemAttributes(itemStack, slot));
        }
        Intrinsics.checkNotNullExpressionValue((Object)results, (String)"results");
        return (Multimap)results;
    }

    @NotNull
    public final Multimap<Attribute, AttributeModifier> getDefaultItemAttributes(@NotNull ItemStack itemStack, @NotNull EquipmentSlot equipmentSlot) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)equipmentSlot, (String)"equipmentSlot");
        if (!this.isSupportedBukkitVersion()) {
            HashMultimap hashMultimap = HashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create()");
            return (Multimap)hashMultimap;
        }
        return this.getItemAttributesByServer().getDefaultItemAttributes(itemStack, equipmentSlot);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lio/pixeloutlaw/minecraft/spigot/plumbing/lib/ItemAttributes$NoOpItemAttributes;", "Lio/pixeloutlaw/minecraft/spigot/plumbing/api/AbstractItemAttributes;", "()V", "getDefaultItemAttributes", "Lcom/google/common/collect/Multimap;", "Lorg/bukkit/attribute/Attribute;", "Lorg/bukkit/attribute/AttributeModifier;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "equipmentSlot", "Lorg/bukkit/inventory/EquipmentSlot;", "plumbing-lib"})
    public static final class NoOpItemAttributes
    implements AbstractItemAttributes {
        @NotNull
        public Multimap<Attribute, AttributeModifier> getDefaultItemAttributes(@NotNull ItemStack itemStack, @NotNull EquipmentSlot equipmentSlot) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter((Object)equipmentSlot, (String)"equipmentSlot");
            HashMultimap hashMultimap = HashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create()");
            return (Multimap)hashMultimap;
        }
    }
}

