/*
 * Decompiled with CFR 0.152.
 */
package io.pixeloutlaw.minecraft.spigot.plumbing.v118R1;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.pixeloutlaw.minecraft.spigot.plumbing.api.AbstractItemAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J$\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/pixeloutlaw/minecraft/spigot/plumbing/v118R1/ItemAttributes;", "Lio/pixeloutlaw/minecraft/spigot/plumbing/api/AbstractItemAttributes;", "()V", "bukkitAttributeList", "", "Lorg/bukkit/attribute/Attribute;", "chestSlot", "Lnet/minecraft/world/entity/EnumItemSlot;", "kotlin.jvm.PlatformType", "feetSlot", "genericAttributeToAttributeMapping", "", "Lnet/minecraft/world/entity/ai/attributes/AttributeBase;", "headSlot", "legsSlot", "mainHandSlot", "nmsAttributeList", "offHandSlot", "convertEquipmentSlotToEnumItemSlot", "equipmentSlot", "Lorg/bukkit/inventory/EquipmentSlot;", "convertGenericAttribute", "genericAttributes", "convertNmsAttributeModifier", "Lorg/bukkit/attribute/AttributeModifier;", "nmsAttributeModifier", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "convertNmsAttributeModifierOperation", "Lorg/bukkit/attribute/AttributeModifier$Operation;", "nmsAttributeModifierOperation", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;", "getDefaultItemAttributes", "Lcom/google/common/collect/Multimap;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "plumbing-1_18_R1"})
public final class ItemAttributes
implements AbstractItemAttributes {
    @NotNull
    public static final ItemAttributes INSTANCE;
    @NotNull
    private static final List<AttributeBase> nmsAttributeList;
    @NotNull
    private static final List<Attribute> bukkitAttributeList;
    @NotNull
    private static final Map<AttributeBase, Attribute> genericAttributeToAttributeMapping;
    private static final EnumItemSlot mainHandSlot;
    private static final EnumItemSlot offHandSlot;
    private static final EnumItemSlot feetSlot;
    private static final EnumItemSlot legsSlot;
    private static final EnumItemSlot chestSlot;
    private static final EnumItemSlot headSlot;

    private ItemAttributes() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Multimap<Attribute, AttributeModifier> getDefaultItemAttributes(@NotNull ItemStack itemStack, @NotNull EquipmentSlot equipmentSlot) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)equipmentSlot, (String)"equipmentSlot");
        ItemStack vanillaItemStack = new ItemStack(itemStack.getType());
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)vanillaItemStack);
        Multimap attributeMap = nmsItemStack.a(this.convertEquipmentSlotToEnumItemSlot(equipmentSlot));
        HashMultimap defaultAttributeMap = HashMultimap.create();
        Iterable $this$forEach$iv = nmsAttributeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<AttributeModifier> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AttributeBase attribute = (AttributeBase)element$iv;
            boolean bl = false;
            Collection attributeModifiers = attributeMap.get((Object)attribute);
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attribute");
            Attribute attribute2 = INSTANCE.convertGenericAttribute(attribute);
            Intrinsics.checkNotNullExpressionValue((Object)attributeModifiers, (String)"attributeModifiers");
            Iterable iterable = CollectionsKt.filterNotNull((Iterable)attributeModifiers);
            Attribute attribute3 = attribute2;
            HashMultimap hashMultimap = defaultAttributeMap;
            boolean $i$f$map = false;
            void var19_19 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                net.minecraft.world.entity.ai.attributes.AttributeModifier attributeModifier = (net.minecraft.world.entity.ai.attributes.AttributeModifier)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(INSTANCE.convertNmsAttributeModifier((net.minecraft.world.entity.ai.attributes.AttributeModifier)it, equipmentSlot));
            }
            collection = (List)destination$iv$iv;
            hashMultimap.putAll((Object)attribute3, (Iterable)collection);
        }
        Intrinsics.checkNotNullExpressionValue((Object)defaultAttributeMap, (String)"defaultAttributeMap");
        return (Multimap)defaultAttributeMap;
    }

    private final AttributeModifier convertNmsAttributeModifier(net.minecraft.world.entity.ai.attributes.AttributeModifier nmsAttributeModifier, EquipmentSlot equipmentSlot) {
        UUID uUID = nmsAttributeModifier.a();
        String string = nmsAttributeModifier.b();
        double d = nmsAttributeModifier.d();
        AttributeModifier.Operation operation = nmsAttributeModifier.c();
        Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"nmsAttributeModifier.c()");
        return new AttributeModifier(uUID, string, d, this.convertNmsAttributeModifierOperation(operation), equipmentSlot);
    }

    private final AttributeModifier.Operation convertNmsAttributeModifierOperation(AttributeModifier.Operation nmsAttributeModifierOperation) {
        return switch (WhenMappings.$EnumSwitchMapping$0[nmsAttributeModifierOperation.ordinal()]) {
            case 1 -> AttributeModifier.Operation.ADD_NUMBER;
            case 2 -> AttributeModifier.Operation.ADD_SCALAR;
            case 3 -> AttributeModifier.Operation.MULTIPLY_SCALAR_1;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Attribute convertGenericAttribute(AttributeBase genericAttributes) {
        return genericAttributeToAttributeMapping.get(genericAttributes);
    }

    private final EnumItemSlot convertEquipmentSlotToEnumItemSlot(EquipmentSlot equipmentSlot) {
        return switch (WhenMappings.$EnumSwitchMapping$1[equipmentSlot.ordinal()]) {
            case 1 -> {
                EnumItemSlot var2_2 = mainHandSlot;
                Intrinsics.checkNotNullExpressionValue((Object)var2_2, (String)"mainHandSlot");
                yield var2_2;
            }
            case 2 -> {
                EnumItemSlot var2_3 = offHandSlot;
                Intrinsics.checkNotNullExpressionValue((Object)var2_3, (String)"offHandSlot");
                yield var2_3;
            }
            case 3 -> {
                EnumItemSlot var2_4 = feetSlot;
                Intrinsics.checkNotNullExpressionValue((Object)var2_4, (String)"feetSlot");
                yield var2_4;
            }
            case 4 -> {
                EnumItemSlot var2_5 = legsSlot;
                Intrinsics.checkNotNullExpressionValue((Object)var2_5, (String)"legsSlot");
                yield var2_5;
            }
            case 5 -> {
                EnumItemSlot var2_6 = chestSlot;
                Intrinsics.checkNotNullExpressionValue((Object)var2_6, (String)"chestSlot");
                yield var2_6;
            }
            case 6 -> {
                EnumItemSlot var2_7 = headSlot;
                Intrinsics.checkNotNullExpressionValue((Object)var2_7, (String)"headSlot");
                yield var2_7;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapNotNullTo$iv$iv;
        INSTANCE = new ItemAttributes();
        Object[] objectArray = new AttributeBase[]{GenericAttributes.a, GenericAttributes.b, GenericAttributes.c, GenericAttributes.d, GenericAttributes.e, GenericAttributes.f, GenericAttributes.g, GenericAttributes.h, GenericAttributes.i, GenericAttributes.j, GenericAttributes.k, GenericAttributes.l, GenericAttributes.m};
        nmsAttributeList = CollectionsKt.listOf((Object[])objectArray);
        bukkitAttributeList = ArraysKt.toList((Object[])Attribute.values());
        Iterable $this$mapNotNull$iv = nmsAttributeList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object v0;
            AttributeBase nmsAttribute;
            block4: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                nmsAttribute = (AttributeBase)element$iv$iv;
                boolean bl2 = false;
                for (Object t : (Iterable)bukkitAttributeList) {
                    Attribute bukkitAttribute = (Attribute)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)nmsAttribute.c(), (Object)bukkitAttribute.getKey().getKey())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            Attribute attribute = v0;
            if (attribute == null) {
                pair = null;
            } else {
                Attribute matchingBukkitAttribute = attribute;
                pair = TuplesKt.to((Object)nmsAttribute, (Object)matchingBukkitAttribute);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        genericAttributeToAttributeMapping = MapsKt.toMap((Iterable)((List)var3_3));
        mainHandSlot = EnumItemSlot.a((String)"mainhand");
        offHandSlot = EnumItemSlot.a((String)"offhand");
        feetSlot = EnumItemSlot.a((String)"feet");
        legsSlot = EnumItemSlot.a((String)"legs");
        chestSlot = EnumItemSlot.a((String)"chest");
        headSlot = EnumItemSlot.a((String)"head");
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AttributeModifier.Operation.values().length];
            nArray[AttributeModifier.Operation.a.ordinal()] = 1;
            nArray[AttributeModifier.Operation.b.ordinal()] = 2;
            nArray[AttributeModifier.Operation.c.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EquipmentSlot.values().length];
            nArray[EquipmentSlot.HAND.ordinal()] = 1;
            nArray[EquipmentSlot.OFF_HAND.ordinal()] = 2;
            nArray[EquipmentSlot.FEET.ordinal()] = 3;
            nArray[EquipmentSlot.LEGS.ordinal()] = 4;
            nArray[EquipmentSlot.CHEST.ordinal()] = 5;
            nArray[EquipmentSlot.HEAD.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

