/*
 * Decompiled with CFR 0.152.
 */
package io.pixeloutlaw.minecraft.spigot.plumbing.v116R1;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.pixeloutlaw.minecraft.spigot.plumbing.api.AbstractItemAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.v1_16_R1.AttributeBase;
import net.minecraft.server.v1_16_R1.AttributeModifier;
import net.minecraft.server.v1_16_R1.EnumItemSlot;
import net.minecraft.server.v1_16_R1.GenericAttributes;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftItemStack;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/pixeloutlaw/minecraft/spigot/plumbing/v116R1/ItemAttributes;", "Lio/pixeloutlaw/minecraft/spigot/plumbing/api/AbstractItemAttributes;", "()V", "genericAttributeList", "", "Lnet/minecraft/server/v1_16_R1/AttributeBase;", "kotlin.jvm.PlatformType", "genericAttributeToAttributeMapping", "", "Lorg/bukkit/attribute/Attribute;", "convertEquipmentSlotToEnumItemSlot", "Lnet/minecraft/server/v1_16_R1/EnumItemSlot;", "equipmentSlot", "Lorg/bukkit/inventory/EquipmentSlot;", "convertGenericAttribute", "genericAttributes", "convertNmsAttributeModifier", "Lorg/bukkit/attribute/AttributeModifier;", "nmsAttributeModifier", "Lnet/minecraft/server/v1_16_R1/AttributeModifier;", "convertNmsAttributeModifierOperation", "Lorg/bukkit/attribute/AttributeModifier$Operation;", "nmsAttributeModifierOperation", "Lnet/minecraft/server/v1_16_R1/AttributeModifier$Operation;", "getDefaultItemAttributes", "Lcom/google/common/collect/Multimap;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "plumbing-1_16_R1"})
public final class ItemAttributes
implements AbstractItemAttributes {
    @NotNull
    private final List<AttributeBase> genericAttributeList;
    @NotNull
    private final Map<AttributeBase, Attribute> genericAttributeToAttributeMapping;

    public ItemAttributes() {
        Object[] objectArray = new AttributeBase[]{GenericAttributes.MAX_HEALTH, GenericAttributes.FOLLOW_RANGE, GenericAttributes.KNOCKBACK_RESISTANCE, GenericAttributes.MOVEMENT_SPEED, GenericAttributes.FLYING_SPEED, GenericAttributes.ATTACK_DAMAGE, GenericAttributes.ATTACK_KNOCKBACK, GenericAttributes.ATTACK_SPEED, GenericAttributes.ARMOR, GenericAttributes.ARMOR_TOUGHNESS, GenericAttributes.LUCK, GenericAttributes.SPAWN_REINFORCEMENTS, GenericAttributes.JUMP_STRENGTH};
        this.genericAttributeList = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)GenericAttributes.MAX_HEALTH, (Object)Attribute.GENERIC_MAX_HEALTH), TuplesKt.to((Object)GenericAttributes.FOLLOW_RANGE, (Object)Attribute.GENERIC_FOLLOW_RANGE), TuplesKt.to((Object)GenericAttributes.KNOCKBACK_RESISTANCE, (Object)Attribute.GENERIC_KNOCKBACK_RESISTANCE), TuplesKt.to((Object)GenericAttributes.MOVEMENT_SPEED, (Object)Attribute.GENERIC_MOVEMENT_SPEED), TuplesKt.to((Object)GenericAttributes.FLYING_SPEED, (Object)Attribute.GENERIC_FLYING_SPEED), TuplesKt.to((Object)GenericAttributes.ATTACK_DAMAGE, (Object)Attribute.GENERIC_ATTACK_DAMAGE), TuplesKt.to((Object)GenericAttributes.ATTACK_KNOCKBACK, (Object)Attribute.GENERIC_ATTACK_KNOCKBACK), TuplesKt.to((Object)GenericAttributes.ATTACK_SPEED, (Object)Attribute.GENERIC_ATTACK_SPEED), TuplesKt.to((Object)GenericAttributes.ARMOR, (Object)Attribute.GENERIC_ARMOR), TuplesKt.to((Object)GenericAttributes.ARMOR_TOUGHNESS, (Object)Attribute.GENERIC_ARMOR_TOUGHNESS), TuplesKt.to((Object)GenericAttributes.LUCK, (Object)Attribute.GENERIC_LUCK), TuplesKt.to((Object)GenericAttributes.SPAWN_REINFORCEMENTS, (Object)Attribute.ZOMBIE_SPAWN_REINFORCEMENTS), TuplesKt.to((Object)GenericAttributes.JUMP_STRENGTH, (Object)Attribute.HORSE_JUMP_STRENGTH)};
        this.genericAttributeToAttributeMapping = MapsKt.mapOf((Pair[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Multimap<Attribute, AttributeModifier> getDefaultItemAttributes(@NotNull ItemStack itemStack, @NotNull EquipmentSlot equipmentSlot) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)equipmentSlot, (String)"equipmentSlot");
        ItemStack vanillaItemStack = new ItemStack(itemStack.getType());
        net.minecraft.server.v1_16_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)vanillaItemStack);
        Multimap attributeMap = nmsItemStack.a(this.convertEquipmentSlotToEnumItemSlot(equipmentSlot));
        HashMultimap defaultAttributeMap = HashMultimap.create();
        Iterable $this$forEach$iv = this.genericAttributeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<AttributeModifier> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AttributeBase attribute = (AttributeBase)element$iv;
            boolean bl = false;
            Collection collection2 = attributeMap.get((Object)attribute);
            if (collection2 == null) continue;
            Collection collection3 = collection2;
            boolean bl2 = false;
            boolean bl3 = false;
            Collection attributeModifiers = collection3;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attribute");
            Iterable iterable = attributeModifiers;
            Attribute attribute2 = this.convertGenericAttribute(attribute);
            HashMultimap hashMultimap = defaultAttributeMap;
            boolean $i$f$map = false;
            void var23_23 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                net.minecraft.server.v1_16_R1.AttributeModifier attributeModifier = (net.minecraft.server.v1_16_R1.AttributeModifier)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                AttributeModifier attributeModifier2 = this.convertNmsAttributeModifier((net.minecraft.server.v1_16_R1.AttributeModifier)it, equipmentSlot);
                collection.add(attributeModifier2);
            }
            collection = (List)destination$iv$iv;
            hashMultimap.putAll((Object)attribute2, (Iterable)collection);
        }
        Intrinsics.checkNotNullExpressionValue((Object)defaultAttributeMap, (String)"defaultAttributeMap");
        return (Multimap)defaultAttributeMap;
    }

    private final AttributeModifier convertNmsAttributeModifier(net.minecraft.server.v1_16_R1.AttributeModifier nmsAttributeModifier, EquipmentSlot equipmentSlot) {
        UUID uUID = nmsAttributeModifier.getUniqueId();
        String string = nmsAttributeModifier.getName();
        double d = nmsAttributeModifier.getAmount();
        AttributeModifier.Operation operation = nmsAttributeModifier.getOperation();
        Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"nmsAttributeModifier.operation");
        return new AttributeModifier(uUID, string, d, this.convertNmsAttributeModifierOperation(operation), equipmentSlot);
    }

    private final AttributeModifier.Operation convertNmsAttributeModifierOperation(AttributeModifier.Operation nmsAttributeModifierOperation) {
        AttributeModifier.Operation operation;
        AttributeModifier.Operation operation2 = nmsAttributeModifierOperation;
        int n = WhenMappings.$EnumSwitchMapping$0[operation2.ordinal()];
        switch (n) {
            case 1: {
                operation = AttributeModifier.Operation.ADD_NUMBER;
                break;
            }
            case 2: {
                operation = AttributeModifier.Operation.ADD_SCALAR;
                break;
            }
            case 3: {
                operation = AttributeModifier.Operation.MULTIPLY_SCALAR_1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return operation;
    }

    private final Attribute convertGenericAttribute(AttributeBase genericAttributes) {
        return this.genericAttributeToAttributeMapping.get(genericAttributes);
    }

    private final EnumItemSlot convertEquipmentSlotToEnumItemSlot(EquipmentSlot equipmentSlot) {
        EnumItemSlot enumItemSlot;
        EquipmentSlot equipmentSlot2 = equipmentSlot;
        int n = WhenMappings.$EnumSwitchMapping$1[equipmentSlot2.ordinal()];
        switch (n) {
            case 1: {
                enumItemSlot = EnumItemSlot.MAINHAND;
                break;
            }
            case 2: {
                enumItemSlot = EnumItemSlot.OFFHAND;
                break;
            }
            case 3: {
                enumItemSlot = EnumItemSlot.FEET;
                break;
            }
            case 4: {
                enumItemSlot = EnumItemSlot.LEGS;
                break;
            }
            case 5: {
                enumItemSlot = EnumItemSlot.CHEST;
                break;
            }
            case 6: {
                enumItemSlot = EnumItemSlot.HEAD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return enumItemSlot;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AttributeModifier.Operation.values().length];
            nArray[AttributeModifier.Operation.ADDITION.ordinal()] = 1;
            nArray[AttributeModifier.Operation.MULTIPLY_BASE.ordinal()] = 2;
            nArray[AttributeModifier.Operation.MULTIPLY_TOTAL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EquipmentSlot.values().length];
            nArray[EquipmentSlot.HAND.ordinal()] = 1;
            nArray[EquipmentSlot.OFF_HAND.ordinal()] = 2;
            nArray[EquipmentSlot.FEET.ordinal()] = 3;
            nArray[EquipmentSlot.LEGS.ordinal()] = 4;
            nArray[EquipmentSlot.CHEST.ordinal()] = 5;
            nArray[EquipmentSlot.HEAD.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

