/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.reflectionrewriter;

import io.papermc.asm.ClassInfo;
import io.papermc.asm.ClassInfoProvider;
import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.RewriteRule;
import java.lang.constant.ClassDesc;
import java.lang.invoke.ConstantBootstraps;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class EnumRule {
    private EnumRule() {
    }

    public static RewriteRule create(final String proxyClassName, final Predicate<String> ownerPredicate) {
        RewriteRule rewrite = RewriteRule.forOwner(ConstantBootstraps.class, rf -> rf.plainStaticRewrite(ClassDesc.of(proxyClassName), b -> b.match("enumConstant").desc(new String[]{"(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Enum;"})), (Consumer[])new Consumer[0]);
        RewriteRule enumRule = new RewriteRule(){

            public ClassVisitor createVisitor(int api, ClassVisitor parent, final ClassProcessingContext context) {
                return new ClassVisitor(api, parent){

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        return new EnumMethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions), proxyClassName, context.classInfoProvider(), ownerPredicate);
                    }
                };
            }
        };
        return RewriteRule.chain((RewriteRule[])new RewriteRule[]{rewrite, enumRule});
    }

    public static RewriteRule minecraft(String proxyClassName) {
        return EnumRule.create(proxyClassName, owner -> owner.startsWith("net/minecraft/") || owner.startsWith("com/mojang/"));
    }

    private static final class EnumMethodVisitor
    extends MethodVisitor {
        private final String proxy;
        private final ClassInfoProvider classInfoProvider;
        private final Predicate<String> ownerPredicate;
        private int increaseMaxStack;

        EnumMethodVisitor(int api, MethodVisitor parent, String proxyClassName, ClassInfoProvider classInfoProvider, Predicate<String> ownerPredicate) {
            super(api, parent);
            this.proxy = proxyClassName;
            this.classInfoProvider = classInfoProvider;
            this.ownerPredicate = ownerPredicate;
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack + this.increaseMaxStack, maxLocals);
            this.increaseMaxStack = 0;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (this.ownerPredicate.test(owner) && name.equals("valueOf") && descriptor.equals("(Ljava/lang/String;)L" + owner + ";")) {
                @Nullable ClassInfo info = this.classInfoProvider.info(owner);
                if (info != null && info.isEnum()) {
                    ++this.increaseMaxStack;
                    super.visitLdcInsn((Object)Type.getType((String)("L" + owner + ";")));
                    super.visitMethodInsn(184, this.proxy, name, "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Enum;", false);
                    super.visitTypeInsn(192, owner);
                    return;
                }
            } else if (name.equals("valueOf") && descriptor.equals("(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;") && this.isEnum(owner)) {
                super.visitMethodInsn(opcode, this.proxy, name, descriptor, false);
                return;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        private boolean isEnum(String owner) {
            if (owner.equals("java/lang/Enum")) {
                return true;
            }
            @Nullable ClassInfo info = this.classInfoProvider.info(owner);
            return info != null && info.isEnum();
        }
    }
}

