/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.reflectionrewriter.runtime;

import io.papermc.reflectionrewriter.runtime.DefineClassReflectionProxy;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DefineClassReflectionProxyImpl
implements DefineClassReflectionProxy {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final Map<MethodKey, MethodHandle> handles = new ConcurrentHashMap<MethodKey, MethodHandle>();
    private final Function<byte[], byte[]> classTransformer;

    DefineClassReflectionProxyImpl(Function<byte[], byte[]> classTransformer) {
        this.classTransformer = classTransformer;
    }

    @Override
    public Class<?> defineClass(Object loader, byte[] b, int off, int len) throws ClassFormatError {
        try {
            MethodHandle handle = this.defineClassHandle(loader.getClass(), MethodType.methodType(Class.class, byte[].class, Integer.TYPE, Integer.TYPE));
            if (!(loader instanceof ClassLoader)) {
                return handle.invokeExact(loader, b, off, len);
            }
            byte[] bytes = DefineClassReflectionProxyImpl.slice(b, off, len);
            byte[] transformed = this.classTransformer.apply(bytes);
            return handle.invokeExact(loader, transformed, 0, transformed.length);
        }
        catch (Throwable ex) {
            throw (RuntimeException)DefineClassReflectionProxyImpl.sneakyThrow(ex);
        }
    }

    @Override
    public Class<?> defineClass(Object loader, String name, byte[] b, int off, int len) throws ClassFormatError {
        try {
            MethodHandle handle = this.defineClassHandle(loader.getClass(), MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE));
            if (!(loader instanceof ClassLoader)) {
                return handle.invokeExact(loader, name, b, off, len);
            }
            byte[] bytes = DefineClassReflectionProxyImpl.slice(b, off, len);
            byte[] transformed = this.classTransformer.apply(bytes);
            return handle.invokeExact(loader, name, transformed, 0, transformed.length);
        }
        catch (Throwable ex) {
            throw (RuntimeException)DefineClassReflectionProxyImpl.sneakyThrow(ex);
        }
    }

    @Override
    public Class<?> defineClass(Object loader, @Nullable String name, byte[] b, int off, int len, @Nullable ProtectionDomain protectionDomain) throws ClassFormatError {
        try {
            MethodHandle handle = this.defineClassHandle(loader.getClass(), MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class));
            if (!(loader instanceof ClassLoader)) {
                return handle.invokeExact(loader, name, b, off, len, protectionDomain);
            }
            byte[] bytes = DefineClassReflectionProxyImpl.slice(b, off, len);
            byte[] transformed = this.classTransformer.apply(bytes);
            return handle.invokeExact(loader, name, transformed, 0, transformed.length, protectionDomain);
        }
        catch (Throwable ex) {
            throw (RuntimeException)DefineClassReflectionProxyImpl.sneakyThrow(ex);
        }
    }

    @Override
    public Class<?> defineClass(Object loader, String name, ByteBuffer b, ProtectionDomain protectionDomain) throws ClassFormatError {
        try {
            MethodHandle handle = this.defineClassHandle(loader.getClass(), MethodType.methodType(Class.class, String.class, ByteBuffer.class, ProtectionDomain.class));
            if (!(loader instanceof ClassLoader)) {
                return handle.invokeExact(loader, name, b, protectionDomain);
            }
            byte[] bytes = DefineClassReflectionProxyImpl.slice(b);
            byte[] transformed = this.classTransformer.apply(bytes);
            return handle.invokeExact(loader, name, ByteBuffer.wrap(transformed), protectionDomain);
        }
        catch (Throwable ex) {
            throw (RuntimeException)DefineClassReflectionProxyImpl.sneakyThrow(ex);
        }
    }

    @Override
    public Class<?> defineClass(Object secureLoader, String name, byte[] b, int off, int len, CodeSource cs) {
        try {
            MethodHandle handle = this.defineClassHandle(secureLoader.getClass(), MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, CodeSource.class));
            if (!(secureLoader instanceof SecureClassLoader)) {
                return handle.invokeExact(secureLoader, name, b, off, len, cs);
            }
            byte[] bytes = DefineClassReflectionProxyImpl.slice(b, off, len);
            byte[] transformed = this.classTransformer.apply(bytes);
            return handle.invokeExact(secureLoader, name, transformed, 0, transformed.length, cs);
        }
        catch (Throwable ex) {
            throw (RuntimeException)DefineClassReflectionProxyImpl.sneakyThrow(ex);
        }
    }

    @Override
    public Class<?> defineClass(Object secureLoader, String name, ByteBuffer b, CodeSource cs) {
        try {
            MethodHandle handle = this.defineClassHandle(secureLoader.getClass(), MethodType.methodType(Class.class, String.class, ByteBuffer.class, CodeSource.class));
            if (!(secureLoader instanceof SecureClassLoader)) {
                return handle.invokeExact(secureLoader, name, b, cs);
            }
            byte[] bytes = DefineClassReflectionProxyImpl.slice(b);
            byte[] transformed = this.classTransformer.apply(bytes);
            return handle.invokeExact(secureLoader, name, ByteBuffer.wrap(transformed), cs);
        }
        catch (Throwable ex) {
            throw (RuntimeException)DefineClassReflectionProxyImpl.sneakyThrow(ex);
        }
    }

    @Override
    public Class<?> defineClass(MethodHandles.Lookup lookup, byte[] bytes) throws IllegalAccessException {
        return lookup.defineClass(this.classTransformer.apply(bytes));
    }

    private MethodHandle defineClassHandle(Class<?> loaderType, MethodType methodType) {
        return this.handles.computeIfAbsent(new MethodKey(loaderType, methodType), methodKey -> {
            try {
                return MethodHandles.privateLookupIn(methodKey.owner(), LOOKUP).findVirtual(methodKey.owner(), "defineClass", methodKey.methodType()).asType(methodKey.methodType().insertParameterTypes(0, Object.class));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to lookup defineClass handle", ex);
            }
        });
    }

    private static byte[] slice(byte[] bytes, int start, int len) {
        byte[] ret = new byte[len];
        System.arraycopy(bytes, start, ret, 0, len);
        return ret;
    }

    private static byte[] slice(ByteBuffer b) {
        int len = b.remaining();
        byte[] tb = new byte[len];
        if (b.hasArray()) {
            System.arraycopy(b.array(), b.position() + b.arrayOffset(), tb, 0, len);
        } else {
            b.get(tb);
        }
        return tb;
    }

    private static <X extends Throwable> X sneakyThrow(Throwable ex) throws X {
        throw ex;
    }

    private record MethodKey(Class<?> owner, MethodType methodType) {
    }
}

