/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.method;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.builder.matcher.MethodMatcher;
import io.papermc.asm.rules.generate.GeneratedMethodHolder;
import io.papermc.asm.rules.generate.StaticRewriteGeneratedMethodHolder;
import io.papermc.asm.rules.method.FilteredMethodRewriteRule;
import io.papermc.asm.rules.method.MethodRewriteRule;
import io.papermc.asm.util.DescriptorUtils;
import io.papermc.asm.util.OpcodeUtils;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Executable;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public interface StaticRewrite
extends FilteredMethodRewriteRule {
    public static final String CONSTRUCTOR_METHOD_NAME = "<init>";

    public ClassDesc staticRedirectOwner();

    default public MethodTypeDesc modifyMethodDescriptor(MethodTypeDesc bytecodeDescriptor) {
        return bytecodeDescriptor;
    }

    @Override
    default public MethodRewriteRule.Rewrite rewrite(ClassProcessingContext context, boolean invokeDynamic, int opcode, String owner, String name, MethodTypeDesc descriptor, boolean isInterface) {
        if (OpcodeUtils.isVirtual(opcode, invokeDynamic) || OpcodeUtils.isInterface(opcode, invokeDynamic)) {
            descriptor = descriptor.insertParameterTypes(0, DescriptorUtils.fromOwner(owner));
        } else {
            if (OpcodeUtils.isSpecial(opcode, invokeDynamic)) {
                if (CONSTRUCTOR_METHOD_NAME.equals(name)) {
                    name = "create" + owner.substring(owner.lastIndexOf(47) + 1);
                    descriptor = descriptor.changeReturnType(DescriptorUtils.fromOwner(owner));
                    return new RewriteConstructor(this.staticRedirectOwner(), owner, (String)name, this.modifyMethodDescriptor(descriptor));
                }
                throw new UnsupportedOperationException("Unhandled static rewrite: " + opcode + " " + owner + " " + (String)name + " " + descriptor);
            }
            if (!OpcodeUtils.isStatic(opcode, invokeDynamic)) {
                throw new UnsupportedOperationException("Unhandled static rewrite: " + opcode + " " + owner + " " + (String)name + " " + descriptor);
            }
        }
        return new MethodRewriteRule.RewriteSingle(OpcodeUtils.staticOp(invokeDynamic), DescriptorUtils.toOwner(this.staticRedirectOwner()), (String)name, this.modifyMethodDescriptor(descriptor), false);
    }

    public record RewriteConstructor(ClassDesc staticRedirectOwner, String constructorOwner, String methodName, MethodTypeDesc descriptor) implements MethodRewriteRule.Rewrite
    {
        @Override
        public void apply(MethodVisitor delegate, MethodNode context) {
            boolean wasDup = false;
            boolean handled = false;
            ArrayDeque<String> typeStack = new ArrayDeque<String>();
            for (AbstractInsnNode insn = context.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
                if (insn.getOpcode() == 183 && StaticRewrite.CONSTRUCTOR_METHOD_NAME.equals(((MethodInsnNode)insn).name)) {
                    typeStack.push(((MethodInsnNode)insn).owner);
                }
                if (wasDup && insn.getOpcode() == 187) {
                    TypeInsnNode newNode = (TypeInsnNode)insn;
                    if (typeStack.isEmpty()) {
                        if (!newNode.desc.equals(this.constructorOwner())) {
                            throw new IllegalStateException("typeStack was empty and the 'new' type didn't match the ctor type");
                        }
                        AbstractInsnNode dup = insn.getNext();
                        context.instructions.remove(insn);
                        context.instructions.remove(dup);
                        handled = true;
                        break;
                    }
                    String top = (String)typeStack.pop();
                    if (!newNode.desc.equals(top)) {
                        throw new IllegalStateException("typeStack top " + top + " didn't match expected " + newNode.desc + " from 'new' node");
                    }
                }
                wasDup = insn.getOpcode() == 89;
            }
            if (!handled) {
                throw new IllegalStateException("Didn't find new/dup before invokespecial for ctor");
            }
            delegate.visitMethodInsn(184, DescriptorUtils.toOwner(this.staticRedirectOwner()), this.methodName(), this.descriptor().descriptorString(), false);
        }

        @Override
        public Handle createHandle() {
            return new Handle(6, DescriptorUtils.toOwner(this.staticRedirectOwner()), this.methodName(), this.descriptor().descriptorString(), false);
        }
    }

    public record Plain(Set<Class<?>> owners, MethodMatcher methodMatcher, ClassDesc staticRedirectOwner) implements StaticRewrite
    {
    }

    public static interface Generated
    extends StaticRewrite,
    GeneratedMethodHolder {
        public ClassDesc existingType();

        @Override
        default public ClassDesc staticRedirectOwner() {
            return GeneratedMethodHolder.super.staticRedirectOwner();
        }

        @Override
        default public void generateMethods(RewriteRule.MethodGeneratorFactory methodGeneratorFactory) {
            this.matchingMethodsByName().filter(pair -> this.matchesExistingMethod((MethodTypeDesc)pair.getValue())).forEach(pair -> this.generateMethod((Map.Entry<Executable, ? extends MethodTypeDesc>)pair, methodGeneratorFactory));
        }

        public boolean matchesExistingMethod(MethodTypeDesc var1);

        public static interface Return
        extends Generated,
        StaticRewriteGeneratedMethodHolder.Return {
            @Override
            default public boolean matchesExistingMethod(MethodTypeDesc desc) {
                return desc.returnType().equals(this.existingType());
            }
        }

        public static interface Param
        extends Generated,
        StaticRewriteGeneratedMethodHolder.Param {
            @Override
            default public boolean matchesExistingMethod(MethodTypeDesc desc) {
                return desc.parameterList().stream().anyMatch(Predicate.isEqual(this.existingType()));
            }
        }
    }
}

