/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.method;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.OwnableRewriteRule;
import io.papermc.asm.rules.builder.matcher.MethodMatcher;
import io.papermc.asm.rules.method.MethodRewriteRule;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;

public interface FilteredMethodRewriteRule
extends MethodRewriteRule,
OwnableRewriteRule {
    private static String transformExecutableName(Executable executable) {
        return executable instanceof Constructor ? "<init>" : executable.getName();
    }

    public MethodMatcher methodMatcher();

    @Override
    default public boolean shouldProcess(ClassProcessingContext context, int opcode, String owner, String name, String descriptor, boolean isInterface) {
        return this.matchesOwner(context, owner) && this.methodMatcher().matches(name, descriptor);
    }

    default public Stream<Map.Entry<Executable, MethodTypeDesc>> matchingMethodsByName() {
        return this.owners().stream().flatMap(o -> Stream.concat(Arrays.stream(o.getDeclaredMethods()), Arrays.stream(o.getDeclaredConstructors()))).filter(executable -> Modifier.isPublic(executable.getModifiers())).map(executable -> Map.entry(executable, DescriptorUtils.desc(executable))).filter(pair -> this.methodMatcher().matchesName(FilteredMethodRewriteRule.transformExecutableName((Executable)pair.getKey())));
    }
}

