/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.generate;

import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.generate.GeneratedMethodHolder;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public interface GeneratedMethodSource<C>
extends GeneratedMethodHolder {
    @Override
    default public void generateMethod(Map.Entry<Executable, ? extends MethodTypeDesc> pair, RewriteRule.MethodGeneratorFactory factory) {
        Executable executable = pair.getKey();
        if (executable instanceof java.lang.reflect.Method) {
            java.lang.reflect.Method method = (java.lang.reflect.Method)executable;
            this.generateRegularMethod(factory, method, pair.getValue());
        } else {
            executable = pair.getKey();
            if (executable instanceof Constructor) {
                Constructor constructor = (Constructor)executable;
                this.generateConstructor(factory, constructor, pair.getValue());
            } else {
                throw new IllegalStateException("Unknown executable " + pair.getKey());
            }
        }
    }

    default public MethodTypeDesc computeGeneratedDescriptor(MethodTypeDesc existing, C context) {
        return existing;
    }

    default public void generateParameters(GeneratorAdapter methodGenerator, MethodTypeDesc descriptor, C context) {
        for (int i = 0; i < descriptor.parameterCount(); ++i) {
            methodGenerator.loadArg(i);
        }
    }

    private void generateConstructor(RewriteRule.MethodGeneratorFactory factory, Constructor<?> constructor, MethodTypeDesc descriptor) {
        Class<?> declaringClass = constructor.getDeclaringClass();
        descriptor = descriptor.changeReturnType(constructor.getDeclaringClass().describeConstable().orElseThrow());
        C context = this.createNewContext();
        descriptor = this.computeGeneratedDescriptor(descriptor, context);
        String typeName = DescriptorUtils.toOwner(descriptor.returnType());
        GeneratorAdapter methodGenerator = factory.create(9, "create" + typeName.substring(typeName.lastIndexOf(47) + 1), descriptor.descriptorString());
        methodGenerator.newInstance(Type.getType(declaringClass));
        methodGenerator.dup();
        this.generateParameters(methodGenerator, descriptor, context);
        methodGenerator.invokeConstructor(Type.getType(declaringClass), Method.getMethod(constructor));
        this.generateReturnValue(methodGenerator, constructor);
        methodGenerator.endMethod();
    }

    private void generateRegularMethod(RewriteRule.MethodGeneratorFactory factory, java.lang.reflect.Method method, MethodTypeDesc descriptor) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (!Modifier.isStatic(method.getModifiers())) {
            descriptor = descriptor.insertParameterTypes(0, declaringClass.describeConstable().orElseThrow());
        }
        C context = this.createNewContext();
        descriptor = this.computeGeneratedDescriptor(descriptor, context);
        GeneratorAdapter methodGenerator = factory.create(9, method.getName(), descriptor.descriptorString());
        this.generateParameters(methodGenerator, descriptor, context);
        Method originalMethod = Method.getMethod((java.lang.reflect.Method)method);
        Type originalOwner = Type.getType(declaringClass);
        if (declaringClass.isInterface() && !Modifier.isStatic(method.getModifiers())) {
            methodGenerator.invokeInterface(originalOwner, originalMethod);
        } else if (!declaringClass.isInterface() && !Modifier.isStatic(method.getModifiers())) {
            methodGenerator.invokeVirtual(originalOwner, originalMethod);
        } else if (Modifier.isStatic(method.getModifiers())) {
            methodGenerator.invokeStatic(originalOwner, originalMethod);
        } else {
            throw new IllegalStateException("unknown method type " + methodGenerator);
        }
        this.generateReturnValue(methodGenerator, method);
        methodGenerator.endMethod();
    }

    default public void generateReturnValue(GeneratorAdapter methodGenerator, Executable executable) {
        methodGenerator.returnValue();
    }

    public C createNewContext();

    public static interface NoContext
    extends GeneratedMethodSource<Void> {
        @Override
        default public Void createNewContext() {
            return null;
        }
    }
}

