/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.builder;

import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.builder.RuleFactoryImpl;
import io.papermc.asm.rules.builder.matcher.FieldMatcher;
import io.papermc.asm.rules.builder.matcher.MethodMatcher;
import io.papermc.asm.rules.builder.matcher.TargetedMethodMatcher;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Consumer;

public interface RuleFactory {
    public static RuleFactory create(Set<Class<?>> owners) {
        return new RuleFactoryImpl(owners);
    }

    public static Factory combine(Factory ... factories) {
        return r -> {
            for (Factory factory : factories) {
                factory.accept(r);
            }
        };
    }

    public void plainStaticRewrite(ClassDesc var1, Consumer<? super MethodMatcher.Builder> var2);

    default public void changeParamToSuper(Class<?> oldParamType, Class<?> newParamType, Consumer<? super MethodMatcher.Builder> builderConsumer) {
        if (!newParamType.isAssignableFrom(oldParamType)) {
            throw new IllegalArgumentException(newParamType + " is not a superclass of " + oldParamType);
        }
        this.changeParamToSuper(DescriptorUtils.desc(oldParamType), DescriptorUtils.desc(newParamType), builderConsumer);
    }

    public void changeParamToSuper(ClassDesc var1, ClassDesc var2, Consumer<? super MethodMatcher.Builder> var3);

    default public void changeParamFuzzy(ClassDesc newOwner, Class<?> newParamType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeParamFuzzy(newOwner, DescriptorUtils.desc(newParamType), staticHandler, builderConsumer);
    }

    public void changeParamFuzzy(ClassDesc var1, ClassDesc var2, Method var3, Consumer<? super TargetedMethodMatcher.Builder> var4);

    default public void changeParamDirect(ClassDesc newOwner, Class<?> newParamType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeParamDirect(newOwner, DescriptorUtils.desc(newParamType), staticHandler, builderConsumer);
    }

    public void changeParamDirect(ClassDesc var1, ClassDesc var2, Method var3, Consumer<? super TargetedMethodMatcher.Builder> var4);

    default public void changeReturnTypeToSub(Class<?> oldReturnType, Class<?> newReturnType, Consumer<? super MethodMatcher.Builder> builderConsumer) {
        if (!oldReturnType.isAssignableFrom(newReturnType)) {
            throw new IllegalArgumentException(newReturnType + " is not a subclass of " + oldReturnType);
        }
        this.changeReturnTypeToSub(DescriptorUtils.desc(oldReturnType), DescriptorUtils.desc(newReturnType), builderConsumer);
    }

    public void changeReturnTypeToSub(ClassDesc var1, ClassDesc var2, Consumer<? super MethodMatcher.Builder> var3);

    default public void changeReturnTypeFuzzy(ClassDesc newOwner, Class<?> newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeFuzzy(newOwner, DescriptorUtils.desc(newReturnType), staticHandler, builderConsumer);
    }

    public void changeReturnTypeFuzzy(ClassDesc var1, ClassDesc var2, Method var3, Consumer<? super TargetedMethodMatcher.Builder> var4);

    default public void changeReturnTypeDirect(ClassDesc newOwner, Class<?> newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeDirect(newOwner, DescriptorUtils.desc(newReturnType), staticHandler, builderConsumer);
    }

    public void changeReturnTypeDirect(ClassDesc var1, ClassDesc var2, Method var3, Consumer<? super TargetedMethodMatcher.Builder> var4);

    default public void changeReturnTypeFuzzyWithContext(ClassDesc newOwner, Class<?> newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeFuzzyWithContext(newOwner, DescriptorUtils.desc(newReturnType), staticHandler, builderConsumer);
    }

    public void changeReturnTypeFuzzyWithContext(ClassDesc var1, ClassDesc var2, Method var3, Consumer<? super TargetedMethodMatcher.Builder> var4);

    default public void changeReturnTypeDirectWithContext(ClassDesc newOwner, Class<?> newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeDirectWithContext(newOwner, DescriptorUtils.desc(newReturnType), staticHandler, builderConsumer);
    }

    public void changeReturnTypeDirectWithContext(ClassDesc var1, ClassDesc var2, Method var3, Consumer<? super TargetedMethodMatcher.Builder> var4);

    public void renameField(String var1, Consumer<? super FieldMatcher.Builder> var2);

    public void addRule(RewriteRule var1);

    public RewriteRule build();

    @FunctionalInterface
    public static interface Factory
    extends Consumer<RuleFactory> {
        @Override
        public void accept(RuleFactory var1);
    }
}

