/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractFixedSizeExemplarReservoir
implements ExemplarReservoir {
    private final Clock clock;
    private final ReservoirCell[] storage;

    AbstractFixedSizeExemplarReservoir(Clock clock, int size) {
        this.clock = clock;
        this.storage = new ReservoirCell[size];
        for (int i = 0; i < size; ++i) {
            this.storage[i] = new ReservoirCell();
        }
    }

    protected final int maxSize() {
        return this.storage.length;
    }

    protected abstract int reservoirIndexFor(double var1, Attributes var3, Context var4);

    protected void reset() {
    }

    @Override
    public final void offerMeasurement(long value, Attributes attributes, Context context) {
        this.offerMeasurement((double)value, attributes, context);
    }

    @Override
    public final void offerMeasurement(double value, Attributes attributes, Context context) {
        int bucket = this.reservoirIndexFor(value, attributes, context);
        if (bucket != -1) {
            this.storage[bucket].offerMeasurement(value, attributes, context);
        }
    }

    @Override
    public final List<ExemplarData> collectAndReset(Attributes pointAttributes) {
        ArrayList<ExemplarData> results = new ArrayList<ExemplarData>();
        for (ReservoirCell reservoirCell : this.storage) {
            ExemplarData result = reservoirCell.getAndReset(pointAttributes);
            if (result == null) continue;
            results.add(result);
        }
        this.reset();
        return Collections.unmodifiableList(results);
    }

    private static Attributes filtered(Attributes original, Attributes metricPoint) {
        if (metricPoint.isEmpty()) {
            return original;
        }
        Set metricPointKeys = metricPoint.asMap().keySet();
        return original.toBuilder().removeIf(metricPointKeys::contains).build();
    }

    private class ReservoirCell {
        private double value;
        @Nullable
        private Attributes attributes;
        @Nullable
        private String spanId;
        @Nullable
        private String traceId;
        private long recordTime;

        private ReservoirCell() {
        }

        synchronized void offerMeasurement(double value, Attributes attributes, Context context) {
            this.value = value;
            this.attributes = attributes;
            this.recordTime = AbstractFixedSizeExemplarReservoir.this.clock.now();
            this.updateFromContext(context);
        }

        private void updateFromContext(Context context) {
            Span current = Span.fromContext((Context)context);
            if (current.getSpanContext().isValid()) {
                this.spanId = current.getSpanContext().getSpanId();
                this.traceId = current.getSpanContext().getTraceId();
            }
        }

        @Nullable
        synchronized ExemplarData getAndReset(Attributes pointAttributes) {
            Attributes attributes = this.attributes;
            if (attributes != null) {
                DoubleExemplarData result = DoubleExemplarData.create(AbstractFixedSizeExemplarReservoir.filtered(attributes, pointAttributes), this.recordTime, this.spanId, this.traceId, this.value);
                this.attributes = null;
                this.value = 0.0;
                this.spanId = null;
                this.traceId = null;
                this.recordTime = 0L;
                return result;
            }
            return null;
        }
    }
}

