/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.metrics.SdkMeter;
import io.opentelemetry.sdk.metrics.SdkMeterBuilder;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import io.opentelemetry.sdk.metrics.internal.export.CollectionHandle;
import io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistry;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Logger;

public final class SdkMeterProvider
implements MeterProvider,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(SdkMeterProvider.class.getName());
    static final String DEFAULT_METER_NAME = "unknown";
    private final ComponentRegistry<SdkMeter> registry;
    private final MeterProviderSharedState sharedState;
    private final Map<CollectionHandle, CollectionInfo> collectionInfoMap;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicLong lastCollectionTimestamp;
    private final long minimumCollectionIntervalNanos;

    public static SdkMeterProviderBuilder builder() {
        return new SdkMeterProviderBuilder();
    }

    SdkMeterProvider(List<MetricReaderFactory> readerFactories, Clock clock, Resource resource, ViewRegistry viewRegistry, ExemplarFilter exemplarSampler, long minimumCollectionIntervalNanos) {
        this.sharedState = MeterProviderSharedState.create(clock, resource, viewRegistry, exemplarSampler);
        this.registry = new ComponentRegistry(instrumentationLibraryInfo -> new SdkMeter(this.sharedState, (InstrumentationLibraryInfo)instrumentationLibraryInfo));
        this.lastCollectionTimestamp = new AtomicLong(clock.nanoTime() - minimumCollectionIntervalNanos);
        this.minimumCollectionIntervalNanos = minimumCollectionIntervalNanos;
        Set<CollectionHandle> collectors = CollectionHandle.mutableSet();
        this.collectionInfoMap = new HashMap<CollectionHandle, CollectionInfo>();
        Supplier<CollectionHandle> handleSupplier = CollectionHandle.createSupplier();
        for (MetricReaderFactory readerFactory : readerFactories) {
            CollectionHandle handle = handleSupplier.get();
            MetricReader reader = readerFactory.apply(new LeasedMetricProducer(handle));
            this.collectionInfoMap.put(handle, CollectionInfo.create(handle, collectors, reader));
            collectors.add(handle);
        }
    }

    public MeterBuilder meterBuilder(String instrumentationName) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            LOGGER.fine("Meter requested without instrumentation name.");
            instrumentationName = DEFAULT_METER_NAME;
        }
        return new SdkMeterBuilder(this.registry, instrumentationName);
    }

    public CompletableResultCode forceFlush() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        for (CollectionInfo collectionInfo : this.collectionInfoMap.values()) {
            results.add(collectionInfo.getReader().flush());
        }
        return CompletableResultCode.ofAll(results);
    }

    public CompletableResultCode shutdown() {
        if (!this.isClosed.compareAndSet(false, true)) {
            LOGGER.info("Multiple close calls");
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        for (CollectionInfo info : this.collectionInfoMap.values()) {
            results.add(info.getReader().shutdown());
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    private class LeasedMetricProducer
    implements MetricProducer {
        private final CollectionHandle handle;

        LeasedMetricProducer(CollectionHandle handle) {
            this.handle = handle;
        }

        @Override
        public Collection<MetricData> collectAllMetrics() {
            CollectionInfo info;
            long pastNanoTime;
            boolean disableSynchronousCollection;
            Collection meters = SdkMeterProvider.this.registry.getComponents();
            long currentNanoTime = SdkMeterProvider.this.sharedState.getClock().nanoTime();
            boolean bl = disableSynchronousCollection = currentNanoTime - (pastNanoTime = SdkMeterProvider.this.lastCollectionTimestamp.get()) < SdkMeterProvider.this.minimumCollectionIntervalNanos;
            if (!disableSynchronousCollection) {
                SdkMeterProvider.this.lastCollectionTimestamp.lazySet(currentNanoTime);
            }
            if ((info = (CollectionInfo)SdkMeterProvider.this.collectionInfoMap.get(this.handle)) == null) {
                throw new IllegalStateException("No collection info for handle, this is a bug in the OpenTelemetry SDK.");
            }
            ArrayList<MetricData> result = new ArrayList<MetricData>();
            for (SdkMeter meter : meters) {
                result.addAll(meter.collectAll(info, SdkMeterProvider.this.sharedState.getClock().now(), disableSynchronousCollection));
            }
            return Collections.unmodifiableCollection(result);
        }
    }
}

