/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import io.opentelemetry.exporter.internal.retry.RetryUtil;
import io.opentelemetry.exporter.logging.SystemOutLogExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogExporterBuilder;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.logs.export.LogExporter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

class LogExporterConfiguration {
    private static final String EXPORTER_NONE = "none";

    static Map<String, LogExporter> configureLogExporters(ConfigProperties config, MeterProvider meterProvider, BiFunction<? super LogExporter, ConfigProperties, ? extends LogExporter> logExporterCustomizer) {
        Set<String> exporterNames = DefaultConfigProperties.getSet(config, "otel.logs.exporter");
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton(EXPORTER_NONE);
        }
        if (exporterNames.contains(EXPORTER_NONE)) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException("otel.logs.exporter contains none along with other exporters");
            }
            return Collections.emptyMap();
        }
        HashMap<String, LogExporter> exportersByName = new HashMap<String, LogExporter>();
        for (String name : exporterNames) {
            LogExporter logExporter = LogExporterConfiguration.configureExporter(name, config, meterProvider);
            if (logExporter == null) continue;
            LogExporter customizedLogExporter = logExporterCustomizer.apply((LogExporter)logExporter, config);
            exportersByName.put(name, customizedLogExporter);
        }
        return Collections.unmodifiableMap(exportersByName);
    }

    @Nullable
    static LogExporter configureExporter(String name, ConfigProperties config, MeterProvider meterProvider) {
        switch (name) {
            case "otlp": {
                return LogExporterConfiguration.configureOtlpLogs(config, meterProvider);
            }
            case "logging": {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.SystemOutLogExporter", "Logging Log Exporter", "opentelemetry-exporter-logging");
                return SystemOutLogExporter.create();
            }
        }
        throw new ConfigurationException("Unrecognized value for otel.logs.exporter: " + name);
    }

    @Nullable
    static LogExporter configureOtlpLogs(ConfigProperties config, MeterProvider meterProvider) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("logs", config);
        if (protocol.equals("http/protobuf")) {
            try {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogExporter", "OTLP HTTP Log Exporter", "opentelemetry-exporter-otlp-http-logs");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpHttpLogExporterBuilder builder = OtlpHttpLogExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, arg_0 -> ((OtlpHttpLogExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpLogExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpLogExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpLogExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpLogExporterBuilder)builder).setTrustedCertificates(arg_0), (arg_0, arg_1) -> ((OtlpHttpLogExporterBuilder)builder).setClientTls(arg_0, arg_1), retryPolicy -> RetryUtil.setRetryPolicyOnDelegate((Object)builder, (RetryPolicy)retryPolicy));
            builder.setMeterProvider(meterProvider);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            try {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogExporter", "OTLP gRPC Log Exporter", "opentelemetry-exporter-otlp-logs");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpGrpcLogExporterBuilder builder = OtlpGrpcLogExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, arg_0 -> ((OtlpGrpcLogExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcLogExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcLogExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcLogExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcLogExporterBuilder)builder).setTrustedCertificates(arg_0), (arg_0, arg_1) -> ((OtlpGrpcLogExporterBuilder)builder).setClientTls(arg_0, arg_1), retryPolicy -> RetryUtil.setRetryPolicyOnDelegate((Object)builder, (RetryPolicy)retryPolicy));
            builder.setMeterProvider(meterProvider);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP logs protocol: " + protocol);
    }

    private LogExporterConfiguration() {
    }
}

