/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.autoconfigure.LogExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.LogProcessor;
import io.opentelemetry.sdk.logs.SdkLogEmitterProvider;
import io.opentelemetry.sdk.logs.SdkLogEmitterProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogProcessor;
import io.opentelemetry.sdk.logs.export.LogExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogProcessor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class LogEmitterProviderConfiguration {
    static SdkLogEmitterProvider configureLogEmitterProvider(Resource resource, ConfigProperties config, MeterProvider meterProvider) {
        SdkLogEmitterProviderBuilder builder = SdkLogEmitterProvider.builder().setResource(resource);
        Map<String, LogExporter> exportersByName = LogExporterConfiguration.configureLogExporters(config, meterProvider);
        LogEmitterProviderConfiguration.configureLogProcessors(exportersByName).forEach(arg_0 -> ((SdkLogEmitterProviderBuilder)builder).addLogProcessor(arg_0));
        SdkLogEmitterProvider logEmitterProvider = builder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkLogEmitterProvider)logEmitterProvider).close()));
        return logEmitterProvider;
    }

    static List<LogProcessor> configureLogProcessors(Map<String, LogExporter> exportersByName) {
        HashMap<String, LogExporter> exportersByNameCopy = new HashMap<String, LogExporter>(exportersByName);
        ArrayList<LogProcessor> logProcessors = new ArrayList<LogProcessor>();
        LogExporter exporter = (LogExporter)exportersByNameCopy.remove("logging");
        if (exporter != null) {
            logProcessors.add(SimpleLogProcessor.create((LogExporter)exporter));
        }
        if (!exportersByNameCopy.isEmpty()) {
            LogExporter compositeLogExporter = LogExporter.composite(exportersByNameCopy.values());
            logProcessors.add((LogProcessor)BatchLogProcessor.builder((LogExporter)compositeLogExporter).build());
        }
        return logProcessors;
    }

    private LogEmitterProviderConfiguration() {
    }
}

