/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.buffer.Buffer;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ServerChannelReadHandleFactory;
import io.netty5.channel.ServerChannelWriteHandleFactory;
import io.netty5.channel.nio.AbstractNioMessageChannel;
import io.netty5.channel.socket.ServerSocketChannel;
import io.netty5.channel.socket.nio.NioChannelOption;
import io.netty5.channel.socket.nio.NioChannelUtil;
import io.netty5.channel.socket.nio.NioSocketChannel;
import io.netty5.util.NetUtil;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.SocketUtils;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public class NioServerSocketChannel
extends AbstractNioMessageChannel<Channel, SocketAddress, SocketAddress>
implements ServerSocketChannel {
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketChannel.class);
    private static final Method OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY = NioChannelUtil.findOpenMethod("openServerSocketChannel");
    private final ProtocolFamily family;
    private final EventLoopGroup childEventLoopGroup;
    private volatile int backlog = NetUtil.SOMAXCONN;
    private volatile boolean bound;

    private static java.nio.channels.ServerSocketChannel newChannel(SelectorProvider provider, ProtocolFamily family) {
        try {
            java.nio.channels.ServerSocketChannel channel = (java.nio.channels.ServerSocketChannel)NioChannelUtil.newChannel(OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY, provider, family);
            return channel == null ? provider.openServerSocketChannel() : channel;
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
    }

    public NioServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup) {
        this(eventLoop, childEventLoopGroup, DEFAULT_SELECTOR_PROVIDER);
    }

    public NioServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, SelectorProvider provider) {
        this(eventLoop, childEventLoopGroup, provider, null);
    }

    public NioServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, SelectorProvider provider, ProtocolFamily protocolFamily) {
        this(eventLoop, childEventLoopGroup, NioServerSocketChannel.newChannel(provider, NioChannelUtil.toJdkFamily(protocolFamily)), protocolFamily);
    }

    public NioServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, java.nio.channels.ServerSocketChannel channel) {
        this(eventLoop, childEventLoopGroup, channel, null);
    }

    public NioServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, java.nio.channels.ServerSocketChannel channel, ProtocolFamily family) {
        super(null, eventLoop, false, new ServerChannelReadHandleFactory(), new ServerChannelWriteHandleFactory(), channel, 16);
        this.family = NioChannelUtil.toJdkFamily(family);
        this.childEventLoopGroup = NioServerSocketChannel.validateEventLoopGroup(childEventLoopGroup, "childEventLoopGroup", NioSocketChannel.class);
    }

    @Override
    public EventLoopGroup childEventLoopGroup() {
        return this.childEventLoopGroup;
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.bound;
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        if (option == ChannelOption.SO_BACKLOG) {
            return (T)Integer.valueOf(this.getBacklog());
        }
        SocketOption<T> socketOption = NioChannelOption.toSocketOption(option);
        if (socketOption != null) {
            return NioChannelOption.getOption(this.javaChannel(), socketOption);
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        if (option == ChannelOption.SO_BACKLOG) {
            this.setBacklog((Integer)value);
        } else {
            SocketOption<T> socketOption = NioChannelOption.toSocketOption(option);
            if (socketOption != null) {
                NioChannelOption.setOption(this.javaChannel(), socketOption, value);
            } else {
                super.setExtendedOption(option, value);
            }
        }
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        if (option == ChannelOption.SO_BACKLOG) {
            return true;
        }
        SocketOption<?> socketOption = NioChannelOption.toSocketOption(option);
        if (socketOption != null) {
            return NioChannelOption.isOptionSupported(this.javaChannel(), socketOption);
        }
        return super.isExtendedOptionSupported(option);
    }

    private int getBacklog() {
        return this.backlog;
    }

    private void setBacklog(int backlog) {
        ObjectUtil.checkPositiveOrZero((int)backlog, (String)"backlog");
        this.backlog = backlog;
    }

    @Override
    protected java.nio.channels.ServerSocketChannel javaChannel() {
        return (java.nio.channels.ServerSocketChannel)super.javaChannel();
    }

    @Override
    protected SocketAddress localAddress0() {
        try {
            SocketAddress address = this.javaChannel().getLocalAddress();
            if (NioChannelUtil.isDomainSocket(this.family)) {
                address = NioChannelUtil.toDomainSocketAddress(address);
            }
            return address;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        return !this.isActive();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        if (NioChannelUtil.isDomainSocket(this.family)) {
            localAddress = NioChannelUtil.toUnixDomainSocketAddress(localAddress);
        }
        this.javaChannel().bind(localAddress, this.getBacklog());
        this.bound = true;
    }

    @Override
    protected int doReadMessages(AbstractChannel.ReadSink readSink) throws Exception {
        SocketChannel ch = SocketUtils.accept((java.nio.channels.ServerSocketChannel)this.javaChannel());
        try {
            if (ch != null) {
                readSink.processRead(0, 0, new NioSocketChannel(this, this.childEventLoopGroup().next(), ch, this.family));
                return 1;
            }
        }
        catch (Throwable t) {
            logger.warn("Failed to create a new channel from an accepted socket.", t);
            try {
                ch.close();
            }
            catch (Throwable t2) {
                logger.warn("Failed to close a socket.", t2);
            }
        }
        readSink.processRead(0, 0, null);
        return 0;
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean doFinishConnect(SocketAddress requestedRemoteAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeHandle) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final Object filterOutboundMessage(Object msg) {
        throw new UnsupportedOperationException();
    }
}

