/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Predicate;

final class ByteBufferCollector
implements Predicate<Object> {
    private static final FastThreadLocal<BufferCache> NIO_BUFFERS = new FastThreadLocal<BufferCache>(){

        protected BufferCache initialValue() {
            BufferCache cache = new BufferCache();
            cache.buffers = new ByteBuffer[1024];
            return cache;
        }
    };
    private int maxCount;
    private long maxBytes;
    private BufferCache cache;

    ByteBufferCollector() {
    }

    int nioBufferCount() {
        return this.cache.bufferCount;
    }

    long nioBufferSize() {
        return this.cache.totalSize;
    }

    ByteBuffer[] nioBuffers() {
        return this.cache.buffers;
    }

    void reset() {
        int count;
        if (this.cache == null) {
            this.cache = (BufferCache)NIO_BUFFERS.get();
        }
        if ((count = this.cache.bufferCount) > 0) {
            Arrays.fill(this.cache.buffers, 0, count, null);
        }
        this.cache.bufferCount = 0;
        this.cache.totalSize = 0L;
        this.cache = null;
    }

    void prepare(int maxCount, long maxBytes) {
        assert (maxCount > 0);
        assert (maxBytes > 0L);
        this.maxCount = maxCount;
        this.maxBytes = maxBytes;
        this.cache = (BufferCache)NIO_BUFFERS.get();
        this.cache.bufferCount = 0;
        this.cache.totalSize = 0L;
    }

    @Override
    public boolean test(Object msg) throws RuntimeException {
        if (!(msg instanceof Buffer)) {
            return false;
        }
        Buffer buf = (Buffer)msg;
        if (buf.readableBytes() == 0) {
            return true;
        }
        try (ComponentIterator iterator = buf.forEachComponent();){
            BufferComponent c = (BufferComponent)iterator.firstReadable();
            while (c != null) {
                ByteBuffer byteBuffer = c.readableBuffer();
                if (this.cache.bufferCount > 0 && this.cache.totalSize + (long)byteBuffer.remaining() > this.maxBytes) {
                    boolean bl = false;
                    return bl;
                }
                this.cache.totalSize += (long)byteBuffer.remaining();
                ByteBuffer[] buffers = this.cache.buffers;
                int bufferCount = this.cache.bufferCount;
                if (buffers.length == bufferCount && bufferCount < this.maxCount) {
                    this.cache.buffers = ByteBufferCollector.expandNioBufferArray(buffers, bufferCount + 1, bufferCount);
                    buffers = this.cache.buffers;
                }
                buffers[this.cache.bufferCount] = byteBuffer;
                this.cache.bufferCount = ++bufferCount;
                if (this.maxCount <= bufferCount) {
                    boolean bl = false;
                    return bl;
                }
                c = (BufferComponent)((ComponentIterator.Next)c).nextReadable();
            }
        }
        return true;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] array, int neededSpace, int size) {
        int newCapacity = array.length;
        do {
            if ((newCapacity <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (neededSpace > newCapacity);
        ByteBuffer[] newArray = new ByteBuffer[newCapacity];
        System.arraycopy(array, 0, newArray, 0, size);
        return newArray;
    }

    private static final class BufferCache {
        ByteBuffer[] buffers;
        long totalSize;
        int bufferCount;

        private BufferCache() {
        }
    }
}

