/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.local;

import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.AbstractServerChannel;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.local.LocalAddress;
import io.netty5.channel.local.LocalChannel;
import io.netty5.channel.local.LocalChannelRegistry;
import io.netty5.channel.local.LocalChannelUnsafe;
import io.netty5.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;

public class LocalServerChannel
extends AbstractServerChannel<LocalChannel, LocalAddress, LocalAddress>
implements LocalChannelUnsafe {
    private final Queue<Object> inboundBuffer = new ArrayDeque<Object>();
    private volatile int state;
    private volatile LocalAddress localAddress;
    private volatile boolean acceptInProgress;

    public LocalServerChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup) {
        super(eventLoop, childEventLoopGroup, LocalChannel.class);
        this.setOption(ChannelOption.BUFFER_ALLOCATOR, DefaultBufferAllocators.onHeapAllocator());
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    @Override
    protected LocalAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, localAddress);
        this.state = 1;
    }

    @Override
    protected void doClose() throws Exception {
        if (this.state <= 1) {
            if (this.localAddress != null) {
                LocalChannelRegistry.unregister(this.localAddress);
                this.localAddress = null;
            }
            this.state = 2;
        }
    }

    @Override
    protected void doRead(boolean wasReadPendingAlready) throws Exception {
        if (this.acceptInProgress) {
            return;
        }
        Queue<Object> inboundBuffer = this.inboundBuffer;
        if (inboundBuffer.isEmpty()) {
            this.acceptInProgress = true;
            return;
        }
        this.readNow();
    }

    LocalChannel serve(LocalChannel peer) {
        LocalChannel child = this.newLocalChannel(peer);
        if (this.executor().inEventLoop()) {
            this.serve0(child);
        } else {
            this.executor().execute(() -> this.serve0(child));
        }
        return child;
    }

    @Override
    protected boolean doReadNow(AbstractChannel.ReadSink readSink) {
        Object m = this.inboundBuffer.poll();
        readSink.processRead(0, 0, m);
        return false;
    }

    protected LocalChannel newLocalChannel(LocalChannel peer) {
        return new LocalChannel(this, this.childEventLoopGroup().next(), peer);
    }

    private void serve0(LocalChannel child) {
        this.inboundBuffer.add(child);
        if (this.acceptInProgress) {
            this.acceptInProgress = false;
            this.readNow();
        }
    }

    @Override
    public void registerTransportNow() {
    }

    @Override
    public void deregisterTransportNow() {
    }

    @Override
    public void closeTransportNow() {
        this.closeTransport((Promise<Void>)this.newPromise());
    }
}

