/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.group;

import io.netty5.channel.Channel;
import io.netty5.channel.group.ChannelGroup;
import io.netty5.channel.group.ChannelGroupException;
import io.netty5.channel.group.ChannelGroupFuture;
import io.netty5.util.concurrent.BlockingOperationException;
import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.ImmediateEventExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

final class DefaultChannelGroupFuture
extends DefaultPromise<Void>
implements ChannelGroupFuture {
    private final ChannelGroup group;
    private final Map<Channel, Future<Void>> futures;
    private int successCount;
    private int failureCount;
    private final FutureListener<Void> childListener = new FutureListener<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(Future<? extends Void> future) throws Exception {
            boolean callSetDone;
            boolean success = future.isSuccess();
            DefaultChannelGroupFuture defaultChannelGroupFuture = DefaultChannelGroupFuture.this;
            synchronized (defaultChannelGroupFuture) {
                if (success) {
                    ++DefaultChannelGroupFuture.this.successCount;
                } else {
                    ++DefaultChannelGroupFuture.this.failureCount;
                }
                boolean bl = callSetDone = DefaultChannelGroupFuture.this.successCount + DefaultChannelGroupFuture.this.failureCount == DefaultChannelGroupFuture.this.futures.size();
                assert (DefaultChannelGroupFuture.this.successCount + DefaultChannelGroupFuture.this.failureCount <= DefaultChannelGroupFuture.this.futures.size());
            }
            if (callSetDone) {
                if (DefaultChannelGroupFuture.this.failureCount > 0) {
                    ArrayList<Map.Entry<Channel, Throwable>> failed = new ArrayList<Map.Entry<Channel, Throwable>>(DefaultChannelGroupFuture.this.failureCount);
                    for (Map.Entry<Channel, Future<Void>> entry : DefaultChannelGroupFuture.this.futures.entrySet()) {
                        if (!entry.getValue().isFailed()) continue;
                        failed.add(new DefaultEntry<Channel, Throwable>(entry.getKey(), entry.getValue().cause()));
                    }
                    DefaultChannelGroupFuture.this.setFailure0(new ChannelGroupException(failed));
                } else {
                    DefaultChannelGroupFuture.this.setSuccess0();
                }
            }
        }
    };

    DefaultChannelGroupFuture(ChannelGroup group, Map<Channel, Future<Void>> futures, EventExecutor executor) {
        super(executor);
        this.group = group;
        this.futures = Collections.unmodifiableMap(futures);
        for (Future<Void> f : this.futures.values()) {
            f.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setSuccess0();
        }
    }

    @Override
    public ChannelGroup group() {
        return this.group;
    }

    @Override
    public Future<Void> find(Channel channel) {
        return this.futures.get(channel);
    }

    @Override
    public Iterator<Future<Void>> iterator() {
        return this.futures.values().iterator();
    }

    @Override
    public synchronized boolean isPartialSuccess() {
        return this.successCount != 0 && this.successCount != this.futures.size();
    }

    @Override
    public synchronized boolean isPartialFailure() {
        return this.failureCount != 0 && this.failureCount != this.futures.size();
    }

    @Override
    public DefaultChannelGroupFuture addListener(FutureListener<? super Void> listener) {
        super.addListener(listener);
        return this;
    }

    public DefaultChannelGroupFuture await() throws InterruptedException {
        super.await();
        return this;
    }

    @Override
    public ChannelGroupException cause() {
        return (ChannelGroupException)super.cause();
    }

    private void setSuccess0() {
        super.setSuccess(null);
    }

    private void setFailure0(ChannelGroupException cause) {
        super.setFailure((Throwable)cause);
    }

    public DefaultChannelGroupFuture setSuccess(Void result) {
        throw new IllegalStateException();
    }

    public boolean trySuccess(Void result) {
        throw new IllegalStateException();
    }

    public DefaultChannelGroupFuture setFailure(Throwable cause) {
        throw new IllegalStateException();
    }

    public boolean tryFailure(Throwable cause) {
        throw new IllegalStateException();
    }

    protected void checkDeadLock() {
        EventExecutor e = this.executor();
        if (e != null && e != ImmediateEventExecutor.INSTANCE && e.inEventLoop()) {
            throw new BlockingOperationException();
        }
    }

    private static final class DefaultEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        DefaultEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("read-only");
        }
    }
}

