/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.ChannelException;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ServerChannel;
import io.netty5.channel.ServerChannelFactory;
import io.netty5.util.internal.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Objects;

public final class ReflectiveServerChannelFactory<T extends ServerChannel>
implements ServerChannelFactory<T> {
    private final Constructor<? extends T> constructor;

    public ReflectiveServerChannelFactory(Class<? extends T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        try {
            this.constructor = clazz.getConstructor(EventLoop.class, EventLoopGroup.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + StringUtil.simpleClassName(clazz) + " does not have a public constructor that takes an EventLoop and EventLoopGroup instance", e);
        }
    }

    @Override
    public T newChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup) {
        try {
            return (T)((ServerChannel)this.constructor.newInstance(eventLoop, childEventLoopGroup));
        }
        catch (Throwable t) {
            throw new ChannelException("Unable to create ServerChannel from class " + this.constructor.getDeclaringClass(), t);
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(ReflectiveServerChannelFactory.class) + "(" + StringUtil.simpleClassName(this.constructor.getDeclaringClass()) + ".class)";
    }
}

