/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.IoHandler;
import io.netty5.channel.IoHandlerFactory;
import io.netty5.channel.SingleThreadEventLoop;
import io.netty5.util.NettyRuntime;
import io.netty5.util.concurrent.DefaultThreadFactory;
import io.netty5.util.concurrent.MultithreadEventExecutorGroup;
import io.netty5.util.concurrent.RejectedExecutionHandler;
import io.netty5.util.concurrent.RejectedExecutionHandlers;
import io.netty5.util.concurrent.ThreadPerTaskExecutor;
import io.netty5.util.internal.EmptyArrays;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    public static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty5.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));

    public MultithreadEventLoopGroup(IoHandlerFactory ioHandlerFactory) {
        this(0, (Executor)null, ioHandlerFactory);
    }

    public MultithreadEventLoopGroup(int nThreads, IoHandlerFactory ioHandlerFactory) {
        this(nThreads, (Executor)null, ioHandlerFactory);
    }

    public MultithreadEventLoopGroup(int nThreads, Executor executor, IoHandlerFactory ioHandlerFactory) {
        this(nThreads, executor, ioHandlerFactory, SingleThreadEventLoop.DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject(), SingleThreadEventLoop.DEFAULT_MAX_TASKS_PER_RUN);
    }

    public MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory) {
        this(nThreads, threadFactory, ioHandlerFactory, SingleThreadEventLoop.DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    public MultithreadEventLoopGroup(Executor executor, IoHandlerFactory ioHandlerFactory) {
        this(0, executor, ioHandlerFactory, SingleThreadEventLoop.DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject(), SingleThreadEventLoop.DEFAULT_MAX_TASKS_PER_RUN);
    }

    public MultithreadEventLoopGroup(ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory) {
        this(0, threadFactory, ioHandlerFactory, SingleThreadEventLoop.DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    public MultithreadEventLoopGroup(int nThreads, Executor executor, IoHandlerFactory ioHandlerFactory, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        this(nThreads, executor, ioHandlerFactory, maxPendingTasks, rejectedHandler, SingleThreadEventLoop.DEFAULT_MAX_TASKS_PER_RUN);
    }

    public MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        this(nThreads, threadFactory, ioHandlerFactory, maxPendingTasks, rejectedHandler, SingleThreadEventLoop.DEFAULT_MAX_TASKS_PER_RUN);
    }

    public MultithreadEventLoopGroup(int nThreads, Executor executor, IoHandlerFactory ioHandlerFactory, int maxPendingTasks, RejectedExecutionHandler rejectedHandler, int maxTasksPerRun) {
        this(nThreads, executor, ioHandlerFactory, maxPendingTasks, rejectedHandler, maxTasksPerRun, EmptyArrays.EMPTY_OBJECTS);
    }

    public MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory, int maxPendingTasks, RejectedExecutionHandler rejectedHandler, int maxTasksPerRun) {
        this(nThreads, threadFactory, ioHandlerFactory, maxPendingTasks, rejectedHandler, maxTasksPerRun, EmptyArrays.EMPTY_OBJECTS);
    }

    protected MultithreadEventLoopGroup(int nThreads, Executor executor, IoHandlerFactory ioHandlerFactory, int maxPendingTasks, RejectedExecutionHandler rejectedHandler, int maxTasksPerRun, Object ... args) {
        super(MultithreadEventLoopGroup.pickThreadCount(nThreads), (Executor)(executor == null ? new ThreadPerTaskExecutor(MultithreadEventLoopGroup.newDefaultThreadFactory()) : executor), maxPendingTasks, rejectedHandler, MultithreadEventLoopGroup.merge(ioHandlerFactory, maxTasksPerRun, args));
    }

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory, int maxPendingTasks, RejectedExecutionHandler rejectedHandler, int maxTasksPerRun, Object ... args) {
        super(MultithreadEventLoopGroup.pickThreadCount(nThreads), threadFactory == null ? MultithreadEventLoopGroup.newDefaultThreadFactory() : threadFactory, maxPendingTasks, rejectedHandler, MultithreadEventLoopGroup.merge(ioHandlerFactory, maxTasksPerRun, args));
    }

    private static ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(MultithreadEventLoopGroup.class, 10);
    }

    protected static int pickThreadCount(int nThreads) {
        return nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads;
    }

    private static Object[] merge(IoHandlerFactory ioHandlerFactory, int maxTasksPerRun, Object ... args) {
        ArrayList<Object> argList = new ArrayList<Object>(2 + args.length);
        argList.add(ioHandlerFactory);
        argList.add(maxTasksPerRun);
        Collections.addAll(argList, args);
        return argList.toArray();
    }

    @Override
    public final EventLoop next() {
        return (EventLoop)super.next();
    }

    protected final EventLoop newChild(Executor executor, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler, Object ... args) {
        return this.newChild(executor, maxPendingTasks, rejectedExecutionHandler, ((IoHandlerFactory)args[0]).newHandler(), (Integer)args[1], Arrays.copyOfRange(args, 2, args.length));
    }

    protected EventLoop newChild(Executor executor, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler, IoHandler ioHandler, int maxTasksPerRun, Object ... args) {
        assert (args.length == 0);
        return new SingleThreadEventLoop(executor, ioHandler, maxPendingTasks, rejectedExecutionHandler, maxTasksPerRun);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty5.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

