/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.channel.AbstractCoalescingBufferQueue;
import io.netty5.channel.Channel;
import io.netty5.util.concurrent.Promise;
import java.util.Objects;

public final class CoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final Channel channel;

    public CoalescingBufferQueue(Channel channel) {
        this(channel, 4);
    }

    public CoalescingBufferQueue(Channel channel, int initSize) {
        super(initSize);
        this.channel = Objects.requireNonNull(channel, "channel");
    }

    public Buffer remove(int bytes, Promise<Void> aggregatePromise) {
        return this.remove(this.channel.bufferAllocator(), bytes, aggregatePromise);
    }

    public void releaseAndFailAll(Throwable cause) {
        this.releaseAndFailAll(this.channel, cause);
    }

    @Override
    protected Buffer compose(BufferAllocator alloc, Buffer cumulation, Buffer next) {
        if (cumulation instanceof CompositeBuffer) {
            CompositeBuffer composite = (CompositeBuffer)cumulation;
            composite.extendWith(next.send());
            return composite;
        }
        return this.composeIntoComposite(alloc, cumulation, next);
    }

    @Override
    protected Buffer removeEmptyValue() {
        return BufferAllocator.offHeapUnpooled().allocate(0);
    }
}

