/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInboundInvoker;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.ReadBufferAllocator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public interface ChannelPipeline
extends ChannelInboundInvoker,
ChannelOutboundInvoker,
Iterable<Map.Entry<String, ChannelHandler>> {
    public ChannelPipeline addFirst(String var1, ChannelHandler var2);

    public ChannelPipeline addLast(String var1, ChannelHandler var2);

    public ChannelPipeline addBefore(String var1, String var2, ChannelHandler var3);

    public ChannelPipeline addAfter(String var1, String var2, ChannelHandler var3);

    public ChannelPipeline addFirst(ChannelHandler ... var1);

    public ChannelPipeline addLast(ChannelHandler ... var1);

    default public ChannelPipeline remove(ChannelHandler handler) {
        if (this.removeIfExists(handler) == null) {
            throw new NoSuchElementException();
        }
        return this;
    }

    default public ChannelHandler remove(String name) {
        Object handler = this.removeIfExists(name);
        if (handler == null) {
            throw new NoSuchElementException();
        }
        return handler;
    }

    default public <T extends ChannelHandler> T remove(Class<T> handlerType) {
        T handler = this.removeIfExists(handlerType);
        if (handler == null) {
            throw new NoSuchElementException();
        }
        return handler;
    }

    public <T extends ChannelHandler> T removeIfExists(String var1);

    public <T extends ChannelHandler> T removeIfExists(Class<T> var1);

    public <T extends ChannelHandler> T removeIfExists(ChannelHandler var1);

    public ChannelHandler removeFirst();

    public ChannelHandler removeLast();

    public ChannelPipeline replace(ChannelHandler var1, String var2, ChannelHandler var3);

    public ChannelHandler replace(String var1, String var2, ChannelHandler var3);

    public <T extends ChannelHandler> T replace(Class<T> var1, String var2, ChannelHandler var3);

    default public ChannelHandler first() {
        ChannelHandlerContext ctx = this.firstContext();
        return ctx == null ? null : ctx.handler();
    }

    public ChannelHandlerContext firstContext();

    default public ChannelHandler last() {
        ChannelHandlerContext ctx = this.lastContext();
        return ctx == null ? null : ctx.handler();
    }

    public ChannelHandlerContext lastContext();

    default public boolean isEmpty() {
        return this.lastContext() == null;
    }

    public ChannelHandler get(String var1);

    public <T extends ChannelHandler> T get(Class<T> var1);

    public ChannelHandlerContext context(ChannelHandler var1);

    public ChannelHandlerContext context(String var1);

    public ChannelHandlerContext context(Class<? extends ChannelHandler> var1);

    public Channel channel();

    default public List<String> names() {
        return new ArrayList<String>(this.toMap().keySet());
    }

    public Map<String, ChannelHandler> toMap();

    @Override
    public ChannelPipeline fireChannelRegistered();

    @Override
    public ChannelPipeline fireChannelUnregistered();

    @Override
    public ChannelPipeline fireChannelActive();

    @Override
    public ChannelPipeline fireChannelInactive();

    @Override
    public ChannelPipeline fireChannelShutdown(ChannelShutdownDirection var1);

    @Override
    public ChannelPipeline fireChannelExceptionCaught(Throwable var1);

    @Override
    public ChannelPipeline fireChannelInboundEvent(Object var1);

    @Override
    public ChannelPipeline fireChannelRead(Object var1);

    @Override
    public ChannelPipeline fireChannelReadComplete();

    @Override
    public ChannelPipeline fireChannelWritabilityChanged();

    @Override
    public ChannelPipeline flush();

    @Override
    public ChannelPipeline read(ReadBufferAllocator var1);

    @Override
    public ChannelPipeline read();

    public long pendingOutboundBytes();
}

