/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectPool;
import io.netty5.util.internal.PromiseNotificationUtil;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;
import java.util.function.Predicate;

final class ChannelOutboundBuffer {
    static final int CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD = SystemPropertyUtil.getInt((String)"io.netty5.transport.outboundBufferEntrySizeOverhead", (int)96);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private final EventExecutor executor;
    private Entry flushedEntry;
    private Entry unflushedEntry;
    private Entry tailEntry;
    private int flushed;
    private boolean inFail;
    private boolean closed;
    private volatile long totalPendingSize;

    ChannelOutboundBuffer(EventExecutor executor) {
        this.executor = executor;
    }

    private void incrementPendingOutboundBytes(long size) {
        if (size == 0L) {
            return;
        }
        this.totalPendingSize += size;
    }

    private void decrementPendingOutboundBytes(long size) {
        if (size == 0L) {
            return;
        }
        this.totalPendingSize -= size;
    }

    void addMessage(Object msg, int size, Promise<Void> promise) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        assert (this.executor.inEventLoop());
        Entry entry = Entry.newInstance(msg, size, promise);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
        } else {
            Entry tail = this.tailEntry;
            tail.next = entry;
        }
        this.tailEntry = entry;
        if (this.unflushedEntry == null) {
            this.unflushedEntry = entry;
        }
        this.incrementPendingOutboundBytes(entry.pendingSize);
    }

    void addFlush() {
        assert (this.executor.inEventLoop());
        Entry entry = this.unflushedEntry;
        if (entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = entry;
            }
            Entry prev = null;
            do {
                if (!entry.promise.setUncancellable()) {
                    int pending = entry.cancel();
                    if (prev == null) {
                        this.flushedEntry = entry.next;
                    } else {
                        prev.next = entry.next;
                    }
                    Entry next = entry.next;
                    entry.recycle();
                    entry = next;
                    this.decrementPendingOutboundBytes(pending);
                    continue;
                }
                ++this.flushed;
                prev = entry;
                entry = entry.next;
            } while (entry != null);
            this.unflushedEntry = null;
        }
    }

    Object current() {
        assert (this.executor.inEventLoop());
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return null;
        }
        return entry.msg;
    }

    boolean remove() {
        return this.remove0(null);
    }

    boolean remove(Throwable cause) {
        return this.remove0(Objects.requireNonNull(cause, "cause"));
    }

    private boolean remove0(Throwable cause) {
        assert (this.executor.inEventLoop());
        Entry e = this.flushedEntry;
        if (e == null) {
            return false;
        }
        Object msg = e.msg;
        Promise<Void> promise = e.promise;
        int size = e.pendingSize;
        this.removeEntry(e);
        if (!e.cancelled) {
            SilentDispose.trySilentDispose((Object)msg, (InternalLogger)logger);
            if (cause == null) {
                ChannelOutboundBuffer.safeSuccess(promise);
            } else {
                ChannelOutboundBuffer.safeFail(promise, cause);
            }
            this.decrementPendingOutboundBytes(size);
        }
        e.recycle();
        return true;
    }

    private void removeEntry(Entry e) {
        assert (this.executor.inEventLoop());
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (e == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
            }
        } else {
            this.flushedEntry = e.next;
        }
    }

    int size() {
        assert (this.executor.inEventLoop());
        return this.flushed;
    }

    boolean isEmpty() {
        assert (this.executor.inEventLoop());
        return this.flushed == 0;
    }

    void failFlushedAndClose(Throwable failCause, Throwable closeCause) {
        assert (this.executor.inEventLoop());
        this.failFlushed(failCause);
        this.close(closeCause);
    }

    void failFlushed(Throwable cause) {
        assert (this.executor.inEventLoop());
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (!this.isEmpty()) {
                this.remove(cause);
            }
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Throwable cause) {
        assert (this.executor.inEventLoop());
        if (this.inFail) {
            this.executor.execute(() -> this.close(cause));
            return;
        }
        this.inFail = true;
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (Entry e = this.unflushedEntry; e != null; e = e.recycleAndGetNext()) {
                int size = e.pendingSize;
                this.decrementPendingOutboundBytes(size);
                if (e.cancelled) continue;
                SilentDispose.dispose((Object)e.msg, (InternalLogger)logger);
                ChannelOutboundBuffer.safeFail(e.promise, cause);
            }
        }
        finally {
            this.closed = true;
            this.inFail = false;
        }
    }

    private static void safeSuccess(Promise<Void> promise) {
        PromiseNotificationUtil.trySuccess(promise, null, (InternalLogger)logger);
    }

    private static void safeFail(Promise<Void> promise, Throwable cause) {
        PromiseNotificationUtil.tryFailure(promise, (Throwable)cause, (InternalLogger)logger);
    }

    long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    void forEachFlushedMessage(Predicate<Object> processor) {
        assert (this.executor.inEventLoop());
        Objects.requireNonNull(processor, "processor");
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return;
        }
        do {
            if (entry.cancelled || processor.test(entry.msg)) continue;
            return;
        } while (this.isFlushedEntry(entry = entry.next));
    }

    private boolean isFlushedEntry(Entry e) {
        return e != null && e != this.unflushedEntry;
    }

    private static final class Entry {
        private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool(Entry::new);
        private final ObjectPool.Handle<Entry> handle;
        Entry next;
        Object msg;
        Promise<Void> promise;
        int pendingSize;
        boolean cancelled;

        private Entry(ObjectPool.Handle<Entry> handle) {
            this.handle = handle;
        }

        static Entry newInstance(Object msg, int size, Promise<Void> promise) {
            Entry entry = (Entry)RECYCLER.get();
            entry.msg = msg;
            entry.pendingSize = size + CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD;
            entry.promise = promise;
            return entry;
        }

        int cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                int pSize = this.pendingSize;
                SilentDispose.dispose((Object)this.msg, (InternalLogger)logger);
                this.msg = null;
                this.pendingSize = 0;
                return pSize;
            }
            return 0;
        }

        void recycle() {
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.pendingSize = 0;
            this.cancelled = false;
            this.handle.recycle((Object)this);
        }

        Entry recycleAndGetNext() {
            Entry next = this.next;
            this.recycle();
            return next;
        }
    }
}

