/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.util.concurrent.FastThreadLocal;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.security.AccessController;
import java.util.Map;
import java.util.WeakHashMap;

final class ChannelHandlerMask {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelHandlerMask.class);
    static final int MASK_CHANNEL_EXCEPTION_CAUGHT = 1;
    static final int MASK_CHANNEL_REGISTERED = 2;
    static final int MASK_CHANNEL_UNREGISTERED = 4;
    static final int MASK_CHANNEL_ACTIVE = 8;
    static final int MASK_CHANNEL_INACTIVE = 16;
    static final int MASK_CHANNEL_SHUTDOWN = 32;
    static final int MASK_CHANNEL_READ = 64;
    static final int MASK_CHANNEL_READ_COMPLETE = 128;
    static final int MASK_CHANNEL_INBOUND_EVENT = 256;
    static final int MASK_CHANNEL_WRITABILITY_CHANGED = 512;
    static final int MASK_BIND = 1024;
    static final int MASK_CONNECT = 2048;
    static final int MASK_DISCONNECT = 4096;
    static final int MASK_CLOSE = 8192;
    static final int MASK_SHUTDOWN = 16384;
    static final int MASK_REGISTER = 32768;
    static final int MASK_DEREGISTER = 65536;
    static final int MASK_READ = 131072;
    static final int MASK_WRITE = 262144;
    static final int MASK_FLUSH = 524288;
    static final int MASK_SEND_OUTBOUND_EVENT = 0x100000;
    static final int MASK_PENDING_OUTBOUND_BYTES = 0x200000;
    private static final int MASK_ALL_INBOUND = 1023;
    private static final int MASK_ALL_OUTBOUND = 4193280;
    private static final FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>> MASKS = new FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>>(){

        protected Map<Class<? extends ChannelHandler>, Integer> initialValue() {
            return new WeakHashMap<Class<? extends ChannelHandler>, Integer>(32);
        }
    };

    static int mask(Class<? extends ChannelHandler> clazz) {
        Map cache = (Map)MASKS.get();
        Integer mask = (Integer)cache.get(clazz);
        if (mask == null) {
            mask = ChannelHandlerMask.mask0(clazz);
            cache.put(clazz, mask);
        }
        return mask;
    }

    static boolean isInbound(Class<? extends ChannelHandler> clazz) {
        return (ChannelHandlerMask.mask(clazz) & 0x3FF) != 0;
    }

    static boolean isOutbound(Class<? extends ChannelHandler> clazz) {
        return (ChannelHandlerMask.mask(clazz) & 0x3FFC00) != 0;
    }

    private static int mask0(Class<? extends ChannelHandler> handlerType) {
        int mask = 0;
        mask |= 0x3FF;
        mask |= 0x3FFC00;
        try {
            if (ChannelHandlerMask.isSkippable(handlerType, "channelExceptionCaught", ChannelHandlerContext.class, Throwable.class)) {
                mask &= 0xFFFFFFFE;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelRegistered", ChannelHandlerContext.class)) {
                mask &= 0xFFFFFFFD;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelUnregistered", ChannelHandlerContext.class)) {
                mask &= 0xFFFFFFFB;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelActive", ChannelHandlerContext.class)) {
                mask &= 0xFFFFFFF7;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelInactive", ChannelHandlerContext.class)) {
                mask &= 0xFFFFFFEF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelShutdown", ChannelHandlerContext.class, ChannelShutdownDirection.class)) {
                mask &= 0xFFFFFFDF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelRead", ChannelHandlerContext.class, Object.class)) {
                mask &= 0xFFFFFFBF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelReadComplete", ChannelHandlerContext.class)) {
                mask &= 0xFFFFFF7F;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelWritabilityChanged", ChannelHandlerContext.class)) {
                mask &= 0xFFFFFDFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "channelInboundEvent", ChannelHandlerContext.class, Object.class)) {
                mask &= 0xFFFFFEFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "bind", ChannelHandlerContext.class, SocketAddress.class)) {
                mask &= 0xFFFFFBFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "connect", ChannelHandlerContext.class, SocketAddress.class, SocketAddress.class)) {
                mask &= 0xFFFFF7FF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "disconnect", ChannelHandlerContext.class)) {
                mask &= 0xFFFFEFFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "close", ChannelHandlerContext.class)) {
                mask &= 0xFFFFDFFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "shutdown", ChannelHandlerContext.class, ChannelShutdownDirection.class)) {
                mask &= 0xFFFFBFFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "register", ChannelHandlerContext.class)) {
                mask &= 0xFFFF7FFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "deregister", ChannelHandlerContext.class)) {
                mask &= 0xFFFEFFFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "read", ChannelHandlerContext.class, ReadBufferAllocator.class)) {
                mask &= 0xFFFDFFFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "write", ChannelHandlerContext.class, Object.class)) {
                mask &= 0xFFFBFFFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "flush", ChannelHandlerContext.class)) {
                mask &= 0xFFF7FFFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "sendOutboundEvent", ChannelHandlerContext.class, Object.class)) {
                mask &= 0xFFEFFFFF;
            }
            if (ChannelHandlerMask.isSkippable(handlerType, "pendingOutboundBytes", ChannelHandlerContext.class)) {
                mask &= 0xFFDFFFFF;
            }
        }
        catch (Exception e) {
            PlatformDependent.throwException((Throwable)e);
        }
        return mask;
    }

    private static boolean isSkippable(Class<?> handlerType, String methodName, Class<?> ... paramTypes) throws Exception {
        return AccessController.doPrivileged(() -> {
            Method m;
            try {
                m = handlerType.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Class {} missing method {}, assume we can not skip execution", new Object[]{handlerType, methodName, e});
                }
                return false;
            }
            return m.isAnnotationPresent(Skip.class);
        });
    }

    private ChannelHandlerMask() {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Skip {
    }
}

