/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelHandlerMask;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.util.concurrent.Future;
import java.net.SocketAddress;

public interface ChannelHandler {
    default public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    default public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }

    default public boolean isSharable() {
        return false;
    }

    @ChannelHandlerMask.Skip
    default public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelRegistered();
    }

    @ChannelHandlerMask.Skip
    default public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelUnregistered();
    }

    @ChannelHandlerMask.Skip
    default public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
    }

    @ChannelHandlerMask.Skip
    default public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
    }

    @ChannelHandlerMask.Skip
    default public void channelShutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) throws Exception {
        ctx.fireChannelShutdown(direction);
    }

    @ChannelHandlerMask.Skip
    default public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ctx.fireChannelRead(msg);
    }

    @ChannelHandlerMask.Skip
    default public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }

    @ChannelHandlerMask.Skip
    default public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireChannelInboundEvent(evt);
    }

    @ChannelHandlerMask.Skip
    default public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelWritabilityChanged();
    }

    @ChannelHandlerMask.Skip
    default public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireChannelExceptionCaught(cause);
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
        return ctx.bind(localAddress);
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
        return ctx.connect(remoteAddress, localAddress);
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> disconnect(ChannelHandlerContext ctx) {
        return ctx.disconnect();
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> close(ChannelHandlerContext ctx) {
        return ctx.close();
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> shutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) {
        return ctx.shutdown(direction);
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> register(ChannelHandlerContext ctx) {
        return ctx.register();
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> deregister(ChannelHandlerContext ctx) {
        return ctx.deregister();
    }

    @ChannelHandlerMask.Skip
    default public void read(ChannelHandlerContext ctx, ReadBufferAllocator readBufferAllocator) {
        ctx.read(readBufferAllocator);
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        return ctx.write(msg);
    }

    @ChannelHandlerMask.Skip
    default public void flush(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @ChannelHandlerMask.Skip
    default public Future<Void> sendOutboundEvent(ChannelHandlerContext ctx, Object event) {
        return ctx.sendOutboundEvent(event);
    }

    @ChannelHandlerMask.Skip
    default public long pendingOutboundBytes(ChannelHandlerContext ctx) {
        return 0L;
    }
}

