/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.bootstrap;

import io.netty5.bootstrap.AbstractBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.util.AttributeKey;
import io.netty5.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractBootstrapConfig<B extends AbstractBootstrap<B, C, F>, C extends Channel, F> {
    protected final B bootstrap;

    AbstractBootstrapConfig(B bootstrap) {
        this.bootstrap = (AbstractBootstrap)Objects.requireNonNull(bootstrap, "bootstrap");
    }

    public final SocketAddress localAddress() {
        return ((AbstractBootstrap)this.bootstrap).localAddress();
    }

    public abstract F channelFactory();

    public final ChannelHandler handler() {
        return ((AbstractBootstrap)this.bootstrap).handler();
    }

    public final Map<ChannelOption<?>, Object> options() {
        return ((AbstractBootstrap)this.bootstrap).options();
    }

    public final Map<AttributeKey<?>, Object> attrs() {
        return ((AbstractBootstrap)this.bootstrap).attrs();
    }

    public final EventLoopGroup group() {
        return ((AbstractBootstrap)this.bootstrap).group();
    }

    public String toString() {
        ChannelHandler handler;
        Map<AttributeKey<?>, Object> attrs;
        Map<ChannelOption<?>, Object> options;
        SocketAddress localAddress;
        F factory;
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append('(');
        EventLoopGroup group = this.group();
        if (group != null) {
            buf.append("group: ").append(StringUtil.simpleClassName((Object)group)).append(", ");
        }
        if ((factory = this.channelFactory()) != null) {
            buf.append("channelFactory: ").append(factory).append(", ");
        }
        if ((localAddress = this.localAddress()) != null) {
            buf.append("localAddress: ").append(localAddress).append(", ");
        }
        if (!(options = this.options()).isEmpty()) {
            buf.append("options: ").append(options).append(", ");
        }
        if (!(attrs = this.attrs()).isEmpty()) {
            buf.append("attrs: ").append(attrs).append(", ");
        }
        if ((handler = this.handler()) != null) {
            buf.append("handler: ").append(handler).append(", ");
        }
        if (buf.charAt(buf.length() - 1) == '(') {
            buf.append(')');
        } else {
            buf.setCharAt(buf.length() - 2, ')');
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }
}

