/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.kqueue;

import io.netty5.buffer.Buffer;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.ServerChannelReadHandleFactory;
import io.netty5.channel.ServerChannelWriteHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.kqueue.AbstractKQueueChannel;
import io.netty5.channel.kqueue.AcceptFilter;
import io.netty5.channel.kqueue.BsdSocket;
import io.netty5.channel.kqueue.KQueueChannelOption;
import io.netty5.channel.kqueue.KQueueSocketChannel;
import io.netty5.channel.socket.DomainSocketAddress;
import io.netty5.channel.socket.ServerSocketChannel;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.channel.unix.NativeInetAddress;
import io.netty5.channel.unix.UnixChannel;
import io.netty5.channel.unix.UnixChannelOption;
import io.netty5.util.NetUtil;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.util.Set;

@UnstableApi
public final class KQueueServerSocketChannel
extends AbstractKQueueChannel<UnixChannel>
implements ServerSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueServerSocketChannel.class);
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS = KQueueServerSocketChannel.supportedOptions();
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS_DOMAIN = KQueueServerSocketChannel.supportedOptionsDomainSocket();
    private final EventLoopGroup childEventLoopGroup;
    private final byte[] acceptedAddress = new byte[26];
    private volatile int backlog = NetUtil.SOMAXCONN;
    private volatile boolean enableTcpFastOpen;

    public KQueueServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup) {
        super(null, eventLoop, false, (ReadHandleFactory)new ServerChannelReadHandleFactory(), (WriteHandleFactory)new ServerChannelWriteHandleFactory(), BsdSocket.newSocketStream(), false);
        this.childEventLoopGroup = KQueueServerSocketChannel.validateEventLoopGroup((EventLoopGroup)childEventLoopGroup, (String)"childEventLoopGroup", KQueueSocketChannel.class);
    }

    public KQueueServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, ProtocolFamily protocolFamily) {
        super(null, eventLoop, false, (ReadHandleFactory)new ServerChannelReadHandleFactory(), (WriteHandleFactory)new ServerChannelWriteHandleFactory(), BsdSocket.newSocket(protocolFamily), false);
        this.childEventLoopGroup = KQueueServerSocketChannel.validateEventLoopGroup((EventLoopGroup)childEventLoopGroup, (String)"childEventLoopGroup", KQueueSocketChannel.class);
    }

    public KQueueServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, int fd, ProtocolFamily protocolFamily) {
        this(eventLoop, childEventLoopGroup, new BsdSocket(fd, SocketProtocolFamily.of((ProtocolFamily)protocolFamily)));
    }

    private KQueueServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, BsdSocket socket) {
        super(null, eventLoop, false, (ReadHandleFactory)new ServerChannelReadHandleFactory(), (WriteHandleFactory)new ServerChannelWriteHandleFactory(), socket, KQueueServerSocketChannel.isSoErrorZero(socket));
        this.childEventLoopGroup = KQueueServerSocketChannel.validateEventLoopGroup((EventLoopGroup)childEventLoopGroup, (String)"childEventLoopGroup", KQueueSocketChannel.class);
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        super.doBind(localAddress);
        this.socket.listen(this.getBacklog());
        if (this.socket.protocolFamily() != SocketProtocolFamily.UNIX && this.isTcpFastOpen()) {
            this.socket.setTcpFastOpen(true);
        }
        this.active = true;
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        if (this.isSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_RCVBUF) {
                return (T)Integer.valueOf(this.getReceiveBufferSize());
            }
            if (option == ChannelOption.SO_REUSEADDR) {
                return (T)Boolean.valueOf(this.isReuseAddress());
            }
            if (option == ChannelOption.SO_BACKLOG) {
                return (T)Integer.valueOf(this.getBacklog());
            }
            if (option == ChannelOption.TCP_FASTOPEN) {
                return (T)(this.isTcpFastOpen() ? Integer.valueOf(1) : Integer.valueOf(0));
            }
            if (option == UnixChannelOption.SO_REUSEPORT) {
                return (T)Boolean.valueOf(this.isReusePort());
            }
            if (option == KQueueChannelOption.SO_ACCEPTFILTER) {
                return (T)this.getAcceptFilter();
            }
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        if (this.isSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_RCVBUF) {
                this.setReceiveBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_REUSEADDR) {
                this.setReuseAddress((Boolean)value);
            } else if (option == ChannelOption.SO_BACKLOG) {
                this.setBacklog((Integer)value);
            } else if (option == ChannelOption.TCP_FASTOPEN) {
                this.setTcpFastOpen((Integer)value > 0);
            } else if (option == UnixChannelOption.SO_REUSEPORT) {
                this.setReusePort((Boolean)value);
            } else if (option == KQueueChannelOption.SO_ACCEPTFILTER) {
                this.setAcceptFilter((AcceptFilter)value);
            }
        } else {
            super.setExtendedOption(option, value);
        }
    }

    private boolean isSupported(SocketProtocolFamily protocolFamily, ChannelOption<?> option) {
        if (protocolFamily == SocketProtocolFamily.UNIX) {
            return SUPPORTED_OPTIONS_DOMAIN.contains(option);
        }
        return SUPPORTED_OPTIONS.contains(option);
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return this.isSupported(this.socket.protocolFamily(), option) || super.isExtendedOptionSupported(option);
    }

    private static Set<ChannelOption<?>> supportedOptions() {
        return KQueueServerSocketChannel.newSupportedIdentityOptionsSet((ChannelOption[])new ChannelOption[]{ChannelOption.SO_RCVBUF, ChannelOption.SO_REUSEADDR, ChannelOption.SO_BACKLOG, ChannelOption.TCP_FASTOPEN, UnixChannelOption.SO_REUSEPORT, KQueueChannelOption.SO_ACCEPTFILTER});
    }

    private static Set<ChannelOption<?>> supportedOptionsDomainSocket() {
        return KQueueServerSocketChannel.newSupportedIdentityOptionsSet((ChannelOption[])new ChannelOption[]{ChannelOption.SO_RCVBUF, ChannelOption.SO_REUSEADDR, ChannelOption.SO_BACKLOG, KQueueChannelOption.SO_ACCEPTFILTER});
    }

    private boolean isReuseAddress() {
        try {
            return this.socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getBacklog() {
        return this.backlog;
    }

    private void setBacklog(int backlog) {
        ObjectUtil.checkPositiveOrZero((int)backlog, (String)"backlog");
        this.backlog = backlog;
    }

    private boolean isTcpFastOpen() {
        return this.enableTcpFastOpen;
    }

    private void setTcpFastOpen(boolean enableTcpFastOpen) {
        this.enableTcpFastOpen = enableTcpFastOpen;
    }

    private void setReusePort(boolean reusePort) {
        try {
            this.socket.setReusePort(reusePort);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private boolean isReusePort() {
        try {
            return this.socket.isReusePort();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setAcceptFilter(AcceptFilter acceptFilter) {
        try {
            this.socket.setAcceptFilter(acceptFilter);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private AcceptFilter getAcceptFilter() {
        try {
            return this.socket.getAcceptFilter();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private Channel newChildChannel(int fd, byte[] address, int offset, int len) throws Exception {
        InetSocketAddress remote = this.socket.protocolFamily() == SocketProtocolFamily.UNIX ? null : NativeInetAddress.address((byte[])address, (int)offset, (int)len);
        return new KQueueSocketChannel(this, this.childEventLoopGroup().next(), new BsdSocket(fd, this.socket.protocolFamily()), remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        SocketAddress local = this.localAddress();
        try {
            super.doClose();
        }
        finally {
            String path;
            File socketFile;
            boolean success;
            if (local != null && this.socket.protocolFamily() == SocketProtocolFamily.UNIX && !(success = (socketFile = new File(path = ((DomainSocketAddress)local).path())).delete()) && logger.isDebugEnabled()) {
                logger.debug("Failed to delete a domain socket file: {}", (Object)path);
            }
        }
    }

    public EventLoopGroup childEventLoopGroup() {
        return this.childEventLoopGroup;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    protected void doWriteNow(AbstractChannel.WriteSink writeHandle) {
        throw new UnsupportedOperationException();
    }

    protected Object filterOutboundMessage(Object msg) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) {
        throw new UnsupportedOperationException();
    }

    protected void doShutdown(ChannelShutdownDirection direction) {
        throw new UnsupportedOperationException();
    }

    public boolean isShutdown(ChannelShutdownDirection direction) {
        return !this.isActive();
    }

    @Override
    int readReady(AbstractChannel.ReadSink readSink) throws Exception {
        int acceptFd = this.socket.accept(this.acceptedAddress);
        if (acceptFd == -1) {
            readSink.processRead(0, 0, null);
            return 0;
        }
        readSink.processRead(0, 0, (Object)this.newChildChannel(acceptFd, this.acceptedAddress, 1, this.acceptedAddress[0]));
        return 1;
    }
}

