/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.BufferAllocator;
import io.netty5.handler.ssl.ApplicationProtocolConfig;
import io.netty5.handler.ssl.CipherSuiteFilter;
import io.netty5.handler.ssl.ClientAuth;
import io.netty5.handler.ssl.OpenSsl;
import io.netty5.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty5.handler.ssl.OpenSslEngine;
import io.netty5.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty5.handler.ssl.SslContextOption;
import java.security.cert.Certificate;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public abstract class OpenSslContext
extends ReferenceCountedOpenSslContext {
    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apnCfg, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, OpenSslContext.toNegotiator(apnCfg), mode, keyCertChain, clientAuth, protocols, startTls, enableOcsp, false, options);
    }

    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, OpenSslApplicationProtocolNegotiator apn, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, apn, mode, keyCertChain, clientAuth, protocols, startTls, enableOcsp, false, options);
    }

    @Override
    final SSLEngine newEngine0(BufferAllocator alloc, String peerHost, int peerPort, boolean jdkCompatibilityMode) {
        return new OpenSslEngine(this, alloc, peerHost, peerPort, jdkCompatibilityMode);
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        OpenSsl.releaseIfNeeded(this);
    }
}

