/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.handler.ssl.VectoredUnwrap;
import io.netty5.util.internal.PlatformDependent;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

class EngineWrapper {
    private static final ByteBuffer EMPTY_BUFFER_DIRECT = ByteBuffer.allocateDirect(0);
    private static final ByteBuffer EMPTY_BUFFER_HEAP = ByteBuffer.allocate(0);
    private final SSLEngine engine;
    private final boolean useDirectBuffer;
    private final ByteBuffer[] singleEmptyBuffer;
    private final ByteBuffer[] singleReadableBuffer;
    private final ByteBuffer[] singleWritableBuffer;
    private ByteBuffer[] inputs;
    private ByteBuffer[] outputs;
    private SSLEngineResult result;
    private ByteBuffer cachedReadingBuffer;
    private ByteBuffer cachedWritingBuffer;
    private boolean writeBack;

    EngineWrapper(SSLEngine engine, boolean useDirectBuffer) {
        this.engine = Objects.requireNonNull(engine, "engine");
        this.useDirectBuffer = useDirectBuffer;
        this.singleEmptyBuffer = new ByteBuffer[1];
        this.singleEmptyBuffer[0] = useDirectBuffer ? EMPTY_BUFFER_DIRECT : EMPTY_BUFFER_HEAP;
        this.singleReadableBuffer = new ByteBuffer[1];
        this.singleWritableBuffer = new ByteBuffer[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLEngineResult wrap(Buffer in, Buffer out) throws SSLException {
        try {
            this.prepare(in, out);
            int count = this.outputs.length;
            assert (count == 1) : "Wrap can only output to a single buffer, but got " + count + " buffers.";
            SSLEngineResult sSLEngineResult = this.processResult(this.engine.wrap(this.inputs, this.outputs[0]));
            return sSLEngineResult;
        }
        finally {
            this.finish(in, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLEngineResult unwrap(Buffer in, int length, Buffer out) throws SSLException {
        try {
            this.prepare(in, out);
            this.limitInput(length);
            if (this.engine instanceof VectoredUnwrap) {
                VectoredUnwrap vectoredEngine = (VectoredUnwrap)((Object)this.engine);
                SSLEngineResult sSLEngineResult = this.processResult(vectoredEngine.unwrap(this.inputs, this.outputs));
                return sSLEngineResult;
            }
            if (this.inputs.length > 1) {
                this.coalesceInputs();
            }
            SSLEngineResult sSLEngineResult = this.processResult(this.engine.unwrap(this.inputs[0], this.outputs));
            return sSLEngineResult;
        }
        finally {
            this.finish(in, out);
        }
    }

    private void prepare(Buffer in, Buffer out) {
        int prepared;
        int count;
        if (in == null || in.readableBytes() == 0) {
            this.inputs = this.singleEmptyBuffer;
        } else if (in.isDirect() == this.useDirectBuffer) {
            count = in.countReadableComponents();
            assert (count > 0) : "Input buffer has readable bytes, but no readable components: " + in;
            this.inputs = count == 1 ? this.singleReadableBuffer : new ByteBuffer[count];
            prepared = this.prepareReadable(in);
            assert (prepared == count) : "Expected to prepare " + count + " buffers, but got " + prepared;
        } else {
            this.inputs = this.singleReadableBuffer;
            int readable = in.readableBytes();
            if (this.cachedReadingBuffer == null || this.cachedReadingBuffer.capacity() < readable) {
                this.cachedReadingBuffer = this.allocateCachingBuffer(readable);
            }
            this.cachedReadingBuffer.clear();
            in.copyInto(in.readerOffset(), this.cachedReadingBuffer, 0, readable);
            this.cachedReadingBuffer.limit(readable);
            this.inputs[0] = this.cachedReadingBuffer;
        }
        if (out == null || out.writableBytes() == 0) {
            this.outputs = this.singleEmptyBuffer;
        } else if (out.isDirect() == this.useDirectBuffer) {
            count = out.countWritableComponents();
            assert (count > 0) : "Output buffer has writable space, but no writable components: " + out;
            this.outputs = count == 1 ? this.singleWritableBuffer : new ByteBuffer[count];
            prepared = this.prepareWritable(out);
            assert (prepared == count) : "Expected to prepare " + count + " buffers, but got " + prepared;
        } else {
            this.inputs = this.singleWritableBuffer;
            int writable = out.writableBytes();
            if (this.cachedWritingBuffer == null || this.cachedWritingBuffer.capacity() < writable) {
                this.cachedWritingBuffer = this.allocateCachingBuffer(writable);
            }
            this.outputs[0] = this.cachedWritingBuffer.position(0).limit(writable);
            this.writeBack = true;
        }
    }

    private int prepareReadable(Buffer in) {
        int index = 0;
        try (ComponentIterator iterator = in.forEachComponent();){
            BufferComponent c = (BufferComponent)iterator.firstReadable();
            while (c != null) {
                ByteBuffer byteBuffer = InternalBufferUtils.tryGetWritableBufferFromReadableComponent((BufferComponent)c);
                if (byteBuffer == null) {
                    byteBuffer = c.readableBuffer();
                }
                this.inputs[index++] = byteBuffer;
                c = (BufferComponent)((ComponentIterator.Next)c).nextReadable();
            }
        }
        return index;
    }

    private int prepareWritable(Buffer out) {
        int index = 0;
        try (ComponentIterator iterator = out.forEachComponent();){
            BufferComponent c = (BufferComponent)iterator.firstWritable();
            while (c != null) {
                this.outputs[index++] = c.writableBuffer();
                c = (BufferComponent)((ComponentIterator.Next)c).nextWritable();
            }
        }
        return index;
    }

    private ByteBuffer allocateCachingBuffer(int capacity) {
        capacity = PlatformDependent.roundToPowerOfTwo((int)capacity);
        return this.useDirectBuffer ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    private void limitInput(int length) {
        for (ByteBuffer input : this.inputs) {
            int remaining = input.remaining();
            if (remaining > length) {
                input.limit(input.position() + length);
                length = 0;
                continue;
            }
            length -= remaining;
        }
    }

    private void coalesceInputs() {
        int rem = 0;
        for (ByteBuffer input : this.inputs) {
            rem += input.remaining();
        }
        if (this.cachedReadingBuffer == null || this.cachedReadingBuffer.capacity() < rem) {
            this.cachedReadingBuffer = this.allocateCachingBuffer(rem);
        }
        this.cachedReadingBuffer.clear();
        for (ByteBuffer input : this.inputs) {
            this.cachedReadingBuffer.put(input);
        }
        this.cachedReadingBuffer.flip();
        this.singleReadableBuffer[0] = this.cachedReadingBuffer;
        this.inputs = this.singleReadableBuffer;
    }

    private SSLEngineResult processResult(SSLEngineResult result) {
        this.result = result;
        return result;
    }

    private void finish(Buffer in, Buffer out) {
        if (this.result != null) {
            if (in != null) {
                in.skipReadableBytes(this.result.bytesConsumed());
            }
            if (out != null) {
                if (this.writeBack) {
                    assert (this.outputs.length == 1);
                    ByteBuffer buf = this.outputs[0];
                    while (buf.remaining() >= 8) {
                        out.writeLong(buf.getLong());
                    }
                    if (buf.remaining() >= 4) {
                        out.writeInt(buf.getInt());
                    }
                    if (buf.remaining() >= 2) {
                        out.writeShort(buf.getShort());
                    }
                    if (buf.hasRemaining()) {
                        out.writeByte(buf.get());
                    }
                } else {
                    out.skipWritableBytes(this.result.bytesProduced());
                }
            }
            this.result = null;
        }
        this.singleReadableBuffer[0] = null;
        this.singleWritableBuffer[0] = null;
        this.inputs = null;
        this.outputs = null;
        Reference.reachabilityFence(in);
        Reference.reachabilityFence(out);
    }

    public String toString() {
        return "EngineWrapper(for " + this.engine.getPeerPort() + ")";
    }
}

